﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：文字列のフォントを設定して１ページ目中央に描画するプログラム。
  　　　フォントの指定のみを行う。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AddTextSetFont
    {
        public static void Main(String[] args)
        {
            if (args.Length < 7)
            {
                Console.WriteLine("usage: AddTextSetFont in-pdf-file out-pdf-file font-family font-size set-embed set-italic set-weight");
                Console.WriteLine("set-embed, set-italicは trueかfalseで指定してください。");
                return;
            }
            String fontFamily = args[2];
            float fontSize = float.Parse(args[3]);
            String setEmbed = args[4];
            bool embedOrNot;
            String setItalic = args[5];
            bool italicOrNot;
            String fontWeight = args[6];

            //setEmbedの判定
            switch (setEmbed)
            {
                case "true":
                    embedOrNot = true;
                    break;
                case "false":
                    embedOrNot = false;
                    break;
                default:
                    Console.WriteLine("set-embedは trueかfalseで指定してください。");
                    return;
            }

            //setItalicの判定
            switch (setItalic)
            {
                case "true":
                    italicOrNot = true;
                    break;
                case "false":
                    italicOrNot = false;
                    break;
                default:
                    Console.WriteLine("set-italicは trueかfalseで指定してください。");
                    return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        using (PtlPage page = pages.get(0)) // ページの取得(先頭ページを取得)
                        using (PtlContent content = page.getContent()) // ページコンテントの取得
                        using (PtlRect outputRect = page.getViewBox()) // 出力矩形の設定。(ページの大きさを得るためにViewBoxを取得する)
                        using (PtlParamWriteString writeStringParam = new PtlParamWriteString()) // 文字描画のパラメータクラス。
                        using (PtlParamFont font = new PtlParamFont()) //フォント指定に使うパラメータクラス
                        {
                            // フォントの設定
                            // フォントファミリー名
                            font.setName(fontFamily);
                            // フォントのサイズ(ポイント)
                            font.setSize(fontSize);
                            // フォント埋め込みの可否
                            font.setEmbed(embedOrNot);
                            // イタリックか否か
                            font.setItalic(italicOrNot);
                            // フォントウエイト
                            try
                            {
                                font.setWeight((PtlParamFont.WEIGHT)Enum.Parse(typeof(PtlParamFont.WEIGHT), fontWeight));
                            }
                            catch (ArgumentException ex)
                            {//PtlParamFont.WEIGHTの指定が誤っていた場合のエラーメッセージ
                                Console.WriteLine(ex.Message);
                                Console.WriteLine("ERROR : set-weightにはPtlParamFont.WEIGHTに含まれる名前を指定してください。");
                                Console.WriteLine(ex.StackTrace);
                            }
                            // フォントをパラメータクラスへ設定
                            writeStringParam.setFont(font);

                            // 文字列出力 (中央に文字列を作成)
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_CENTER,
                                                "writeString Test : Set Font", writeStringParam);
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
