﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：文字列の透明度を設定して１ページ目中央に描画するプログラム。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AddTextSetOpacity
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: AddTextSetOpacity in-pdf-file out-pdf-file opacity");
                return;
            }

            float opacity = float.Parse(args[2]);
            if ((opacity < 0) || (1.0f < opacity))
            {
                Console.WriteLine("0.0から1.0の範囲で値を設定し直してください。");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        using (PtlPage page = pages.get(0)) // ページの取得(先頭ページを取得)
                        using (PtlContent content = page.getContent()) // ページコンテントの取得
                        using (PtlRect outputRect = page.getViewBox()) // 出力矩形の設定。(ページの大きさを得るためにViewBoxを取得する)
                        using (PtlParamWriteString writeStringParam = new PtlParamWriteString()) // 文字描画のパラメータクラス
                        {
                            // Opacityをパラメータクラスへ設定
                            writeStringParam.setOpacity(opacity);
                            // 文字列出力 (中央に文字列を作成)
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_CENTER,
                                                "writeString Test : set Opacity", writeStringParam);
                        }
                    }
                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
