﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：ページを2つに分解し、それぞれを保存する。
  　　　指定する数は前半ファイルの最後のページ

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AllocatePages
    {
        public static void Main(String[] args)
        {
            if (args.Length < 2)
            {
                Console.WriteLine("usage: AllocatePages in-pdf-file out-pdf-file");
                return;
            }

            float width = 210.0f;  // A4横長
            float height = 297.0f; // A4縦長

            PtlRect[] rect = null;

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                using (PtlPDFDocument docNew = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    try
                    {
                        using (PtlPages pagesNew = docNew.getPages()) //新規PDFページコンテナの取得
                        using (PtlPages pages = doc.getPages()) //入力PDFページコンテナの取得
                        using (PtlRect rectA4V = new PtlRect(0.0f, 0.0f, width, height))// A4縦用紙
                        {
                            rect = new PtlRect[] {new PtlRect(0.0f, height/2, width/2, height),  // 上左
                                      new PtlRect(width/2, height/2, width, height), // 上右
                                      new PtlRect(0.0f, 0.0f, width/2, height/2),    // 下左
                                      new PtlRect(width/2, 0.0f, width, height/2)};  // 下右
                            int numPages = doc.getPageCount();
                            int pageNumber = 0;
                            int i = 0;

                            while (i < numPages)
                            {
                                using (PtlPage pageTemp = new PtlPage()) // 割り付けを行うA4縦ページ
                                {
                                    // 割り付けを行うA4縦ページの追加
                                    pagesNew.append(pageTemp, PtlPages.INSERT_OPTION.OPTION_NONE);

                                    // 追加したページの取得
                                    using (PtlPage pageNew = pagesNew.get(pageNumber))
                                    {
                                        pageNew.setViewBox(rectA4V);

                                        // 割り付けを行うA4縦ページのコンテント取得
                                        using (PtlContent content = pageNew.getContent())
                                        {
                                            // 4ページを1ページに割り付ける
                                            for (int j = 0; j < 4 && i < numPages; ++j, ++i)
                                            {
                                                // 割り付けするページ
                                                using (PtlPage page = pages.get(i))
                                                {
                                                    // ページ割り付け
                                                    content.drawForm(rect[j], PtlContent.ALIGN.ALIGN_CENTER, page);
                                                }
                                            }
                                        }
                                    }
                                    ++pageNumber;
                                }
                            }
                        }
                    }
                    finally
                    {
                        if (rect != null)
                        {
                            for (int i = 0; i < 4; ++i)
                            {
                                rect[i].Dispose();
                            }
                        }
                    }
                    // ファイルに保存します。
                    docNew.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
