﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：PDFファイルの結合

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AppendPages
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: AppendPages in-pdf-file out-pdf-file append-pdf-file");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        using (PtlParamInput appendFile = new PtlParamInput(args[2]))
                        using (PtlPDFDocument doc_app = new PtlPDFDocument())
                        {
                            // 追加するPDFファイルをロードします。
                            doc_app.load(appendFile);

                            // ページの追加(1P目から全頁) OPTION_COPY_OUTLINES = 0x00000004 /* ページ挿入時にあわせてしおりをコピーします。他PDFのページ挿入時に有効となります。 */
                            pages.append(doc_app, 0, (int)PtlPages.NUM_PAGES.PAGE_ALL, PtlPages.INSERT_OPTION.OPTION_COPY_OUTLINES);
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
