﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：ページを2つに分解し、それぞれを保存する。
  　　　指定する数は前半ファイルの最後のページ

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class DividePdf
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: DividePdf in-pdf-file out-folder end-page-of-the-first-half");
                return;
            }
            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);
                    int endOfFirstHalf = int.Parse(args[2]);
                    if (endOfFirstHalf >= doc.getPageCount())
                    {
                        Console.WriteLine("end-of-pages-of-the-first-half should not be bigger than end of pdf.");
                        return;
                    }

                    using (PtlDocProperty docproperty = doc.getDocProperty())// 文書プロパティの取得
                    using (PtlDocInfo docinfo = docproperty.getDocInfo())    // 文書情報の取得
                    using (PtlPDFDocument doc_ext = new PtlPDFDocument())
                    using (PtlDocProperty docproperty_ext = doc_ext.getDocProperty()) // 文書プロパティの取得
                    using (PtlDocInfo docinfo_ext = docproperty_ext.getDocInfo())     // 文書情報の取得
                    using (PtlPages pages_ext = doc_ext.getPages())
                    {
                        String outputfile;
                        int startPage = 1;
                        int endPage = endOfFirstHalf;
                        int pagesToPrint;
                        // タイトルをコピーし、末尾に1/2をつける
                        docinfo_ext.setTitle(docinfo.getTitle() + "1/2");
                        //タイトルについては1/2,2/2を追加する必要あり。

                        // 著者をコピー
                        docinfo_ext.setAuthor(docinfo.getAuthor());

                        // サブジェクトをコピー
                        docinfo_ext.setSubject(docinfo.getSubject());

                        // キーワードをコピー
                        docinfo_ext.setKeywords(docinfo.getKeywords());

                        // クリエータをコピー
                        docinfo_ext.setCreator(docinfo.getCreator());

                        // プロデューサをコピー
                        docinfo_ext.setProducer(docinfo.getProducer());

                        // 作成日付をコピー
                        using (PtlDate dateCreate = docinfo.getCreationDate())
                        {
                            docinfo_ext.setCreationDate(dateCreate);
                        }

                        // 更新日付をコピー
                        using (PtlDate dateMod = docinfo.getModDate())
                        {
                            docinfo_ext.setModDate(dateMod);
                        }

                        // ページ挿入オプション
                        // OPTION_COPY_OUTLINES = 0x00000004 ページ挿入時にあわせてしおりをコピーします。
                        // OPTION_COPY_ATTACHEDFILES    = 0x00000008ページ挿入時にあわせて添付ファイルをコピーします。
                        PtlPages.INSERT_OPTION insertoption = PtlPages.INSERT_OPTION.OPTION_COPY_OUTLINES |PtlPages.INSERT_OPTION.OPTION_COPY_ATTACHEDFILES;

                        // 追加ページ数の算出(startPageからendPageまで。)
                        pagesToPrint = endPage - startPage + 1;
                        // ページの追加
                        // PtlPages.append() のパラメータfromNumは0スタートのため、startPageから1引いています。
                        pages_ext.append(doc, startPage - 1, pagesToPrint, (PtlPages.INSERT_OPTION)insertoption);
                        // 出力ファイル名
                        outputfile = (String)args[1] + "\\" + "output_1.pdf";
                        using (PtlParamOutput outputFile = new PtlParamOutput(outputfile))
                        {
                            // ファイルに保存します。
                            doc_ext.save(outputFile);
                        }
                        //ページを一旦全消去
                        pages_ext.removeAll();


                        // タイトル末尾に2/2をつけたものに変更
                        docinfo_ext.setTitle(docinfo.getTitle() + "2/2");

                        // 後半の追加ページを再度指定
                        startPage = endPage + 1;
                        endPage = doc.getPageCount();  //ページ数を取得し終端ページを指定。

                        // 追加ページ数の算出(startPageからendPageまで。)
                        pagesToPrint = endPage - startPage + 1;

                        // ページの追加
                        // PtlPages.append() のパラメータfromNumは0スタートのため、startPageから1引いています。
                        pages_ext.append(doc, startPage - 1, pagesToPrint, insertoption);

                        // 出力ファイル名を指定
                        outputfile = (String)args[1] + "\\" + "output_2.pdf";
                        using (PtlParamOutput outputFile = new PtlParamOutput(outputfile))
                        {
                            // ファイルに保存します。
                            doc_ext.save(outputFile);
                        }
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
