﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：ページ境界値の取得

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class GetBoundary
    {
        public static void Main(String[] args)
        {
            if (args.Length < 1)
            {
                Console.WriteLine("usage: GetBoundary in-pdf-file");
                return;
            }


            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    // ページ数の取得
                    int numPages = doc.getPageCount();
                    Console.WriteLine("ページ数：" + numPages);
                    if (numPages > 10)
                    {
                        Console.WriteLine("ページ数が10ページを超えています。");
                        Console.WriteLine("ページ境界の値を表示するのは先頭10ページまでとなります。");
                        numPages = 10;
                    }


                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        for (int i = 0; i < numPages; i++)
                        {
                            // 読み込んだページの取得
                            using (PtlPage page = pages.get(i))
                            using (PtlRect mediaBox = page.getMediaBox()) // 読み込んだページのMediaBox取得
                            {
                                Console.WriteLine("ページ：" + (i + 1));
                                float top = mediaBox.getTop();
                                float bottom = mediaBox.getBottom();
                                float left = mediaBox.getLeft();
                                float right = mediaBox.getRight();
                                Console.WriteLine("MediaBox の[top, bottom, left, right]は、");
                                Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]です。");

                                if (page.hasCropBox())
                                {
                                    using (PtlRect cropBox = page.getCropBox())
                                    {
                                        top = cropBox.getTop();
                                        bottom = cropBox.getBottom();
                                        left = cropBox.getLeft();
                                        right = cropBox.getRight();
                                        Console.WriteLine("CropBox の[top, bottom, left, right]は、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]です。");
                                    }
                                }
                                else
                                {
                                    Console.WriteLine("このページにはCropBoxはありません。");
                                }

                                if (page.hasBleedBox())
                                {
                                    using (PtlRect bleedBox = page.getBleedBox())
                                    {
                                        top = bleedBox.getTop();
                                        bottom = bleedBox.getBottom();
                                        left = bleedBox.getLeft();
                                        right = bleedBox.getRight();
                                        Console.WriteLine("BleedBox の[top, bottom, left, right]は、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]です。");
                                    }
                                }
                                else
                                {
                                    Console.WriteLine("このページにはBleedBoxはありません。");
                                }

                                if (page.hasTrimBox())
                                {
                                    using (PtlRect trimBox = page.getTrimBox())
                                    {
                                        top = trimBox.getTop();
                                        bottom = trimBox.getBottom();
                                        left = trimBox.getLeft();
                                        right = trimBox.getRight();
                                        Console.WriteLine("TrimBox の[top, bottom, left, right]は、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]です。");
                                    }
                                }
                                else
                                {
                                    Console.WriteLine("このページにはTrimBoxはありません。");
                                }

                                if (page.hasArtBox())
                                {
                                    using (PtlRect artBox = page.getArtBox())
                                    {
                                        top = artBox.getTop();
                                        bottom = artBox.getBottom();
                                        left = artBox.getLeft();
                                        right = artBox.getRight();
                                        Console.WriteLine("ArtBox の[top, bottom, left, right]は、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]です。");
                                    }
                                }
                                else
                                {
                                    Console.WriteLine("このページにはArtBoxはありません。");
                                }
                            }
                        }
                    }

                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
