﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：ページの移動
  　　　PDF文書の指定したページ範囲を指定した位置に移動します。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class MovePages
    {
        public static void Main(String[] args)
        {
            if (args.Length < 5)
            {
                Console.WriteLine("usage: MovePages in-pdf-file out-pdf-file move-start-page move-end-page where-to-move");
                Console.WriteLine("move-start-page から move-end-page までの範囲を対象に、where-to-move の後ろへページを移動させます。");
                Console.WriteLine("1ページ目より前へ移動させたい場合は where-to-move に0を指定してください。");
                return;
            }
            int moveStart = int.Parse(args[2]);
            int moveEnd = int.Parse(args[3]);
            if ((moveStart < 1) || (moveEnd < 1))
            {
                Console.WriteLine("move-start-page, move-end-pageは正の値を入力してください。");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    int whereToMove = int.Parse(args[4]);
                    if ((whereToMove < 0) || (whereToMove > doc.getPageCount()))
                    {
                        Console.WriteLine("where-to-moveは0からPDFのページ数までを指定してください。");
                        return;
                    }
                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        //移動ページ数の取得
                        int movingPages = moveEnd - moveStart + 1;
                        if (movingPages < 1)
                        {
                            Console.WriteLine("move-start-pageより小さいmove-end-pageを指定することはできません。");
                            return;
                        }

                        if ((moveStart <= whereToMove) && (whereToMove < moveEnd))
                        {
                            Console.WriteLine("where-to-moveは、move-start-pageとmove-end-pageの間で指定することはできません。");
                            return;
                        }

                        // ページの追加
                        if (whereToMove == doc.getPageCount())   //最終ページの後ろに挿入指定の場合
                        {
                            pages.move((int)PtlPages.INSERT_POS.INSERT_LAST, moveStart - 1, movingPages);
                        }
                        else    //それ以外
                        {
                            // PtlPages.move() のパラメータfromNumは0スタートのため、1引いています。
                            pages.move(whereToMove, moveStart - 1, movingPages);
                        }
                    }
                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
