﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：ページ削除
  　　　PDF文書から指定した範囲のページを削除します。
  　　　※ パラメーターの指定で全ページの削除が出来ますが、
  　　　全てのページを削除したらPDFとしてなりたたないのでエラーとなります。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class RemovePages
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: RemovePages in-pdf-file out-pdf-file  remove-start-page remove-end-page");
                Console.WriteLine("remove-start-pageに\"0\"を入力した場合、\"全ページの消去\"を実行します。");
                Console.WriteLine("ただし、全てのページを削除したらPDFとして成り立たないため、エラーとなります。");
                return;
            }
            int removeStart = int.Parse(args[2]);
            if (removeStart < 0)
            {
                Console.WriteLine("remove-start-page には0以上の値を入力してください。");
                Console.WriteLine("usage: RemovePages in-pdf-file out-pdf-file remove-start-page remove-end-page");
                Console.WriteLine("remove-start-pageに\"0\"を入力した場合、\"全ページの消去\"を実行します。");
                Console.WriteLine("ただし、全てのページを削除したらPDFとして成り立たないため、エラーとなります。");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    // リニアライズ
                    //            doc.setSaveOption(PtlPDFDocument.SAVE_OPTIONE.SAVE_LINEARIZE);

                    // ページ数の取得
                    Console.WriteLine("ページ数：" + doc.getPageCount());

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        //削除処理
                        if (removeStart == 0) //removeAll の指定。
                        {
                            pages.removeAll(); // このままsaveするとエラーになります
                        }
                        else
                        {
                            //削除ページ数の算出
                            int removeEnd = int.Parse(args[3]);
                            int pagesToRemove = removeEnd - removeStart + 1;
                            if (pagesToRemove <= 0)
                            {
                                Console.WriteLine("remove-end-page は remove-start-page より小さい値は指定できません。");
                                return;
                            }
                            //ページの削除
                            //PtlPages.remove() のパラメータindexは0スタートのため、removeStartから-1しています。
                            pages.remove(removeStart - 1, pagesToRemove);
                        }
                    }
                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
