﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：A4縦とA4横が混在したPDFの向きを全て横に揃える。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class RotatePage
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: RotatePage in-pdf-file out-pdf-file 回転方向");
                Console.WriteLine("回転方向:\n 0: 右に回転させて合わせる  1: 左に回転させて合わせる");
                return;
            }
            String rotateDirection = args[2];
            switch (rotateDirection)
            {
                case "0":
                case "1":
                    break;
                default:
                    Console.WriteLine("回転方向を正しく指定してください。");
                    Console.WriteLine("usage: RotatePage in-pdf-file out-pdf-file 回転方向");
                    Console.WriteLine("回転方向:\n 0: 右に回転させて合わせる  1: 左に回転させて合わせる");
                    return;
            }


            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    using (PtlPages pages = doc.getPages()) // ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }
                        int numPages = doc.getPageCount();
                        for (int i = 0; i < numPages; i++)
                        {
                            using (PtlPage page = pages.get(i)) //ページオブジェクトの取得
                            using (PtlSize sizeOfPage = page.getSize()) //ページサイズの取得
                            {
                                float width = sizeOfPage.getWidth();
                                float height = sizeOfPage.getHeight();

                                //回転させるかどうかを判定(仮)
                                //縦の方が横より長いもの（縦長のもの）を回転させる
                                if (height > width)
                                {
                                    // 回転角度設定（0, 90, 180, 270）
                                    switch (rotateDirection)
                                    {
                                        case "0":
                                            page.setRotate(90);
                                            break;
                                        case "1":
                                            page.setRotate(270);
                                            break;
                                    }
                                }
                            }
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
