﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：ページ境界値の設定

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class SetBoundary
    {
        public static void Main(String[] args)
        {
            if (args.Length < 2)
            {
                Console.WriteLine("usage: SetBoundary in-pdf-file out-pdf-file");
                return;
            }


            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    // ページ数の取得
                    int numPages = doc.getPageCount();
                    Console.WriteLine("ページ数：" + numPages);


                    int boxType = setBoxType();  //Boxの種類を数値で指定するメソッド
                    int changingPage = setChangingPage();//境界値を変更したいページを指定するメソッド

                    if ((changingPage < 0) || (numPages < changingPage))
                    {
                        Console.WriteLine("変更したいページは正の、全ページ数より少ない値を指定してください。");
                        return;
                    }
                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }
                        // 変更したいページの取得
                        // PtlPages.get() のパラメータindexは0が先頭のため、changingPageから1引いています。
                        using (PtlPage page = pages.get(changingPage - 1))
                        {
                            float top, bottom, left, right;
                            Console.WriteLine("変更したい境界値の数値を入力してください。");
                            Console.Write("top (mm) : ");
                            top = float.Parse(Console.ReadLine());
                            Console.Write("bottom (mm) : ");
                            bottom = float.Parse(Console.ReadLine());
                            Console.Write("left (mm) : ");
                            left = float.Parse(Console.ReadLine());
                            Console.Write("right (mm) : ");
                            right = float.Parse(Console.ReadLine());

                            switch (boxType)
                            {
                                case 1://MediaBox
                                    using (PtlRect mediaBox = new PtlRect(left, bottom, right, top))
                                    {
                                        Console.WriteLine(changingPage + "ページ目 MediaBox の[top, bottom, left, right]を、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]に変更します。");
                                        page.setMediaBox(mediaBox);
                                    }
                                    break;

                                case 2:  //CropBox
                                    using (PtlRect cropBox = new PtlRect(left, bottom, right, top))
                                    {
                                        Console.WriteLine(changingPage + "ページ目 CropBox の[top, bottom, left, right]を、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]に変更します。");
                                        page.setCropBox(cropBox);
                                    }
                                    break;

                                case 3:  //BleedBox
                                    using (PtlRect bleedBox = new PtlRect(left, bottom, right, top))
                                    {
                                        Console.WriteLine(changingPage + "ページ目 BleedBox の[top, bottom, left, right]を、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]に変更します。");
                                        page.setBleedBox(bleedBox);
                                    }

                                    break;

                                case 4:  //TrimBox
                                    using (PtlRect trimBox = new PtlRect(left, bottom, right, top))
                                    {
                                        Console.WriteLine(changingPage + "ページ目 TrimBox の[top, bottom, left, right]を、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]に変更します。");
                                        page.setTrimBox(trimBox);
                                    }
                                    break;

                                case 5:  //ArtBox
                                    using (PtlRect artBox = new PtlRect(left, bottom, right, top))
                                    {
                                        Console.WriteLine(changingPage + "ページ目 ArtBox の[top, bottom, left, right]を、");
                                        Console.WriteLine("[" + top + ", " + bottom + ", " + left + ", " + right + "]に変更します。");
                                        page.setArtBox(artBox);
                                    }
                                    break;
                            }
                        }
                        doc.save(outputFile);
                    }

                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }


        public static int setBoxType()
        {

            int boxType = 0;

            Console.WriteLine("変更したい境界値の種類を数値で指定してください。");
            Console.WriteLine("1: MediaBox, 2: CropBox, 3: BleedBox, 4: TrimBox, 5:ArtBox");
            while ((boxType < 1) || (5 < boxType))
            {
                boxType = int.Parse(Console.ReadLine());
                if ((boxType < 1) || (5 < boxType))
                {
                    Console.WriteLine("数値は1～5の範囲で指定してください。");
                }
            }

            return boxType;
        }

        public static int setChangingPage()
        {
            int changingPage = 0;

            Console.WriteLine("変更したいページを数値で指定してください。");
            while (changingPage < 1)

            {
                changingPage = int.Parse(Console.ReadLine());
                if (changingPage < 1)
                {
                    Console.WriteLine("数値は正の数を指定してください。");
                }
            }
            return changingPage;
        }
    }
}
