﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：PDFの周囲の余白をトリミングします。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;
using System.Linq;

namespace cookbook
{
    public class TrimPages
    {
        public static void Main(String[] args)
        {
            if (args.Length < 2)
            {
                Console.WriteLine("usage: TrimPages in-pdf-file out-pdf-file");
                return;
            }


            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    // ページ数の取得
                    int numPages = doc.getPageCount();
                    Console.WriteLine("ページ数：" + numPages);
                    if (numPages > 10)
                    {
                        Console.WriteLine("ページ数が10ページを超えています。");
                        Console.WriteLine("先頭10ページまでのページ境界変更のログを出力します。");
                        Console.WriteLine("残りのページ境界はログを出力せずに変更されます。\n");
                    }

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }
                        // 変更したいページの取得・テスト用に１ページ目のみ変更させる。
                        // PtlPages.get() のパラメータindexは0が先頭のため、changingPageから1引いています。
                        for (int i = 0; i < numPages; i++)
                        {
                            using (PtlPage page = pages.get(i))
                            using (PtlRect trimBox = page.getTrimBox())
                            using (PtlRect mediaBox = page.getMediaBox())
                            {
                                float[] trimBoxValue = new float[4]; //trimBoxの各座標を格納する配列
                                float[] mediaBoxValue = new float[4]; //trimBoxの各座標を格納する配列
                                trimBoxValue[0] = trimBox.getLeft();
                                trimBoxValue[1] = trimBox.getBottom();
                                trimBoxValue[2] = trimBox.getRight();
                                trimBoxValue[3] = trimBox.getTop();

                                mediaBoxValue[0] = mediaBox.getLeft();
                                mediaBoxValue[1] = mediaBox.getBottom();
                                mediaBoxValue[2] = mediaBox.getRight();
                                mediaBoxValue[3] = mediaBox.getTop();

                                //trimBoxとmediaBoxが異なる場合に、mediaBoxを変更して設定する。
                                if (!trimBoxValue.SequenceEqual(mediaBoxValue))
                                {
                                    // mediaBoxの値の変更
                                    mediaBox.setLeft(trimBoxValue[0]);
                                    mediaBox.setBottom(trimBoxValue[1]);
                                    mediaBox.setRight(trimBoxValue[2]);
                                    mediaBox.setTop(trimBoxValue[3]);

                                    page.setMediaBox(mediaBox); //変更の反映
                                    page.setCropBox(mediaBox); //CropBox,BleedBoxも同じ値を設定する。
                                    page.setBleedBox(mediaBox);

                                    if (i < 10) // メッセージ出力
                                    {
                                        Console.WriteLine((i + 1) + "ページ目 MediaBox の[top, bottom, left, right]を、");
                                        Console.WriteLine("[" + trimBoxValue[3] + ", " + trimBoxValue[1] + ", "
                                                           + trimBoxValue[0] + ", " + trimBoxValue[2] + "]に変更します。");
                                    }
                                }
                            }
                        }
                        doc.save(outputFile);
                    }
                }


            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
