/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：1ページ目に、指定した画像を使ったステンシルマスクをかけます。
  　　　ステンシルマスクで塗りつぶす色はRGBで指定することができます。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;


public class AddImageSetColorkeyMask {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 6) {
            System.out.println("usage: java cookbook.AddImageSetColorkeyMask in-pdf-file out-pdf-file insert-image-file key-colorR key-colorG key-colorB");
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);
            
            //コマンドライン引数の取得
            String imageURI = args[2];
            int numPages = doc.getPageCount();
            System.out.println("ページ数：" + numPages);
            float keyColorR = Float.parseFloat(args[3]);
            float keyColorG = Float.parseFloat(args[4]);
            float keyColorB = Float.parseFloat(args[5]);


            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }
                
                try (PtlPage page = pages.get(0);// 先頭ページの取得(パラメータindexは0が先頭)
                     PtlContent content = page.getContent();// ページコンテントの取得
                     PtlRect outputRect = page.getViewBox(); // 出力矩形の設定。(ページの大きさを得るためにViewBoxを取得する)
                     PtlParamInput insertImage = new PtlParamInput(imageURI); //画像指定に使うパラメータクラス
                     PtlColorDeviceRGB colorRGB = new PtlColorDeviceRGB(keyColorR, keyColorG, keyColorB); // カラーキーマスクで除外する色（RGB）を指定。
                     PtlParamDrawImage paramDrawImage = new PtlParamDrawImage()) //画像の描画に使うパラメータクラス
                {
                    //入力画像ストリームの設定
                    paramDrawImage.setImageStream(insertImage);
                    paramDrawImage.setMaskColor(colorRGB,PtlParamDrawImage.MASK_TYPE.MASK_COLORKEY);
                    // 画像出力
                    content.drawImage(outputRect, PtlContent.ALIGN.ALIGN_CENTER, paramDrawImage);
                }
                catch (IllegalArgumentException ex) {//PtlContent.ALIGN指定のエラー処理
                    System.out.println(ex.getMessage());
                    System.out.println("ERROR : alignにはPtlContent.ALIGNに含まれる名前を指定してください。");
                    ex.printStackTrace();
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
