/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：QRコード（PDF）を矩形で指定した位置のすべてのページに貼り付けます。
  　　　ここまでに紹介したものと共通する処理が多いため、
  　　　今回に特有の処理についてdrawForm()メソッドにまとめています。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import java.io.*;
import jp.co.antenna.ptl.*;


public class AddPdfStampOnReceipt {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: java AddPdfStampOnReceipt in-pdf-file out-pdf-file insert-stamp-pdf");
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument();
             BufferedReader br = new BufferedReader(new InputStreamReader(System.in))) {
            // PDFファイルをロードします。
            doc.load(inputFile);
            
            //コマンドライン引数の取得
            String insertPdfURI = args[2];

            try (PtlPages pages = doc.getPages())
            {
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("入力PDFのページコンテナが空");
                    return;
                }
                try (PtlPage page = pages.get(0))// 先頭ページの取得
                {
                    // フォームの描画処理
                    drawPdfStamp(page, insertPdfURI);
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

    public static void drawPdfStamp (PtlPage page, String insertPdfURI) throws PtlException, Exception, Error{
        try(PtlContent content = page.getContent();// 挿入先ページコンテントの取得
            PtlRect outputRect = new PtlRect(160, 55, 200, 75);// 出力矩形の設定
            PtlParamInput insertPdf = new PtlParamInput(insertPdfURI); // 挿入PDF指定に使うパラメータクラス
            PtlPDFDocument doc2 = new PtlPDFDocument()) // 挿入PDFの実体
        {
            doc2.load(insertPdf);
            try(PtlPages pages2 = doc2.getPages())
            {
                // ページコンテナが空かどうか
                if (pages2.isEmpty())
                {
                    System.out.println("挿入するPDFのページコンテナが空");
                    return;
                }
                try(PtlPage pageInsert = pages2.get(0)) // 先頭ページの取得
                {
                    // 指定ページの挿入（）
                    content.drawForm(outputRect, PtlContent.ALIGN.ALIGN_CENTER, pageInsert);
                }
            }
        }
    }
}
