/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：指定したページの指定した位置に画像を挿入します。
  　　　配置矩形のみ、プログラム内で指定します。
  　　　文字の描画に使うパラメータは設定しません。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;


public class AddStampOnReceipt {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: java AddStampOnReceipt in-pdf-file out-pdf-file insert-image-file");
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);
            //コマンドライン引数の取得
            String imageURI = args[2];

            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }
                
                try (PtlPage page = pages.get(0);// ページの取得(パラメータindexは0が先頭のため1を引く)
                     PtlContent content = page.getContent();// ページコンテントの取得
                     PtlRect outputRect = new PtlRect(150, 40, 180, 60);// 出力矩形の設定
                     PtlParamDrawImage paramDrawImage = new PtlParamDrawImage(); //画像の描画に使うパラメータクラス
                     PtlParamInput insertImage = new PtlParamInput(imageURI)) //画像指定に使うパラメータクラス
                {
                    //入力画像ストリームの設定
                    paramDrawImage.setImageStream(insertImage);

                    // 画像出力
                    content.drawImage(outputRect, PtlContent.ALIGN.ALIGN_BOTTOM_LEFT, paramDrawImage);
                }
                catch (IllegalArgumentException ex) {//PtlContent.ALIGN指定のエラー処理
                    System.out.println(ex.getMessage());
                    System.out.println("ERROR : alignにはPtlContent.ALIGNに含まれる名前を指定してください。");
                    ex.printStackTrace();
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
