/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：文字列のフォントを設定して１ページ目中央に描画するプログラム。
  　　　フォントの指定のみを行う。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class AddTextSetFont {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 7) {
            System.out.println("usage: java AddTextSetFont in-pdf-file out-pdf-file font-family font-size set-embed set-italic set-weight");
            System.out.println("set-embed, set-italicは trueかfalseで指定してください。");
            return;
        }
        String fontFamily = args[2];
        float fontSize = Float.parseFloat(args[3]);
        String setEmbed = args[4];
        boolean embedOrNot;
        String setItalic = args[5];
        boolean italicOrNot;
        String fontWeight = args[6];
        
        //setEmbedの判定
        switch(setEmbed)
        {
        case "true":
            embedOrNot = true;
            break;
        case "false":
            embedOrNot = false;
            break;
        default:
            System.err.println("set-embedは trueかfalseで指定してください。");
            return;
        }

        //setItalicの判定
        switch(setItalic)
        {
        case "true":
            italicOrNot = true;
            break;
        case "false":
            italicOrNot = false;
            break;
        default:
            System.err.println("set-italicは trueかfalseで指定してください。");
            return;
        }
        
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }
                
                try (PtlPage page = pages.get(0); // ページの取得(先頭ページを取得)
                     PtlContent content = page.getContent(); // ページコンテントの取得
                     PtlRect outputRect = page.getViewBox(); // 出力矩形の設定。(ページの大きさを得るためにViewBoxを取得する)
                     PtlParamWriteString writeStringParam = new PtlParamWriteString(); // 文字描画のパラメータクラス。
                     PtlParamFont font = new PtlParamFont()) //フォント指定に使うパラメータクラス
                {
                    // フォントの設定
                    // フォントファミリー名
                    font.setName(fontFamily);
                    // フォントのサイズ(ポイント)
                    font.setSize(fontSize);
                    // フォント埋め込みの可否
                    font.setEmbed(embedOrNot);
                    // イタリックか否か
                    font.setItalic(italicOrNot);
                    // フォントウエイト
                    try{
                        font.setWeight(PtlParamFont.WEIGHT.valueOf(fontWeight));
                    }catch (IllegalArgumentException ex){//PtlParamFont.WEIGHTの指定が誤っていた場合のエラーメッセージ
                        System.out.println(ex.getMessage());
                        System.out.println("ERROR : set-weightにはPtlParamFont.WEIGHTに含まれる名前を指定してください。");
                        ex.printStackTrace();
                    }
                    // フォントをパラメータクラスへ設定
                    writeStringParam.setFont(font);

                    // 文字列出力 (中央に文字列を作成)
                    content.writeString(outputRect, PtlContent.ALIGN.ALIGN_CENTER,
                                        "writeString Test : Set Font", writeStringParam);
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
