/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：文字列の透明度を設定して１ページ目中央に描画するプログラム。
  　　　

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class AddTextSetOpacity {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java AddTextSetOpacity in-pdf-file out-pdf-file opacity");
            return;
        }

        float opacity = Float.parseFloat(args[2]);
        if((opacity < 0) || (1.0f < opacity)) {
            System.err.println("0.0から1.0の範囲で値を設定し直してください。");
            return;
        }
        String outputText = String.format("writeString Test : set Opacity as %.1f", opacity);
        
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }
                
                try (PtlPage page = pages.get(0); // ページの取得(先頭ページを取得)
                     PtlContent content = page.getContent(); // ページコンテントの取得
                     PtlRect outputRect = page.getViewBox(); // 出力矩形の設定。(ページの大きさを得るためにViewBoxを取得する)
                     PtlParamWriteString writeStringParam = new PtlParamWriteString()) { // 文字描画のパラメータクラス
                    // Opacityをパラメータクラスへ設定
                    writeStringParam.setOpacity(opacity);
                    // 文字列出力 (中央に文字列を作成)
                    content.writeString(outputRect, PtlContent.ALIGN.ALIGN_CENTER,
                                        outputText, writeStringParam);
                }
            }
            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
