/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：PDFファイルの結合

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class AppendPages {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: java AppendPages in-pdf-file out-pdf-file append-pdf-file");
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                try (PtlParamInput appendFile = new PtlParamInput(args[2]);
                     PtlPDFDocument doc_app = new PtlPDFDocument())
                {
                    // 追加するPDFファイルをロードします。
                    doc_app.load(appendFile);

                    // ページの追加(1P目から全頁) OPTION_COPY_OUTLINES = 0x00000004 /* ページ挿入時にあわせてしおりをコピーします。他PDFのページ挿入時に有効となります。 */
                    pages.append(doc_app, 0, PtlPages.PAGE_ALL, PtlPages.OPTION_COPY_OUTLINES);
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
