/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：入力されたPDFの中で指定したページを抽出して出力する。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class ExtractPages {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("usage: java ExtractPage in-pdf-file out-pdf-file start-page end-page");
            return;
        }

        int startPage = Integer.parseInt(args[2]);
        int endPage = Integer.parseInt(args[3]);
        int pagesToPrint = endPage - startPage + 1;
        if(pagesToPrint < 1)
        {
            System.err.println("ERROR: End-page number should be bigger than start-page number");
            return;
        }
        
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);
            try (PtlDocProperty docproperty = doc.getDocProperty();// 文書プロパティの取得
                 PtlDocInfo docinfo = docproperty.getDocInfo();    // 文書情報の取得
                 PtlPDFDocument doc_ext = new PtlPDFDocument();
                 PtlDocProperty docproperty_ext = doc_ext.getDocProperty(); // 出力側文書プロパティの取得
                 PtlDocInfo docinfo_ext = docproperty_ext.getDocInfo();     // 出力側文書情報の取得
                 PtlPages pages_ext = doc_ext.getPages())
            {
                // タイトルをコピー
                docinfo_ext.setTitle(docinfo.getTitle());

                // 著者をコピー
                docinfo_ext.setAuthor(docinfo.getAuthor());

                // サブジェクトをコピー
                docinfo_ext.setSubject(docinfo.getSubject());

                // キーワードをコピー
                docinfo_ext.setKeywords(docinfo.getKeywords());

                // クリエータをコピー
                docinfo_ext.setCreator(docinfo.getCreator());

                // プロデューサをコピー
                docinfo_ext.setProducer(docinfo.getProducer());

                // 作成日付をコピー
                try (PtlDate dateCreate = docinfo.getCreationDate())
                {
                    docinfo_ext.setCreationDate(dateCreate);
                }

                // 更新日付をコピー
                try (PtlDate dateMod = docinfo.getModDate())
                {
                    docinfo_ext.setModDate(dateMod);
                }

                // ページ挿入オプション
                // OPTION_COPY_OUTLINES = 0x00000004 ページ挿入時にあわせてしおりをコピーします。
                // OPTION_COPY_ATTACHEDFILES    = 0x00000008ページ挿入時にあわせて添付ファイルをコピーします。
                int insertoption = PtlPages.OPTION_COPY_OUTLINES | PtlPages.OPTION_COPY_ATTACHEDFILES;

                // ページの追加
                // PtlPages.append() のパラメータfromNumは0スタートのため、startPageから1引いています。
                pages_ext.append(doc, startPage - 1, pagesToPrint, insertoption);

                // ファイルに保存します。
                doc_ext.save(outputFile);
            }
	    
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
