/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：ページ境界値の取得

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class GetBoundary {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: java GetBoundary in-pdf-file");
            return;
        }


        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            // ページ数の取得
            int numPages = doc.getPageCount();
            System.out.println("ページ数：" + numPages);
            if(numPages > 10)
            {
                System.out.println("ページ数が10ページを超えています。");
                System.out.println("ページ境界の値を表示するのは先頭10ページまでとなります。");
                numPages = 10;
            }

			
            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }

                for (int i = 0; i < numPages; i++)
                {
                    // 読み込んだページの取得
                    try (PtlPage page = pages.get(i);
                         PtlRect mediaBox = page.getMediaBox()) // 読み込んだページのMediaBox取得
                    {
                        System.out.println("ページ：" + (i+1));
                        float top = mediaBox.getTop();
                        float bottom = mediaBox.getBottom();
                        float left = mediaBox.getLeft();
                        float right = mediaBox.getRight();
                        System.out.println("MediaBox の[top, bottom, left, right]は、");
                        System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]です。"); 

                        if(page.hasCropBox())
                        {
                            try(PtlRect cropBox = page.getCropBox())
                            {
                                top = cropBox.getTop();
                                bottom = cropBox.getBottom();
                                left = cropBox.getLeft();
                                right = cropBox.getRight();
                                System.out.println("CropBox の[top, bottom, left, right]は、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]です。"); 
                            }
                        }
                        else
                        {
                            System.out.println("このページにはCropBoxはありません。");
                        }

                        if(page.hasBleedBox())
                        {
                            try(PtlRect bleedBox = page.getBleedBox())
                            {
                                top = bleedBox.getTop();
                                bottom = bleedBox.getBottom();
                                left = bleedBox.getLeft();
                                right = bleedBox.getRight();
                                System.out.println("BleedBox の[top, bottom, left, right]は、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]です。"); 
                            }
                        }
                        else
                        {
                            System.out.println("このページにはBleedBoxはありません。");
                        }

                        if(page.hasTrimBox())
                        {
                            try(PtlRect trimBox = page.getTrimBox())
                            {
                                top = trimBox.getTop();
                                bottom = trimBox.getBottom();
                                left = trimBox.getLeft();
                                right = trimBox.getRight();
                                System.out.println("TrimBox の[top, bottom, left, right]は、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]です。"); 
                            }
                        }
                        else
                        {
                            System.out.println("このページにはTrimBoxはありません。");
                        }
			
                        if(page.hasArtBox())
                        {
                            try(PtlRect artBox = page.getArtBox())
                            {
                                top = artBox.getTop();
                                bottom = artBox.getBottom();
                                left = artBox.getLeft();
                                right = artBox.getRight();
                                System.out.println("ArtBox の[top, bottom, left, right]は、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]です。"); 
                            }
                        }
                        else
                        {
                            System.out.println("このページにはArtBoxはありません。");
                        }
                    }
                }
            }
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }


}
