/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：総ページ数を調べ、総ページ数が奇数のとき、最後に空白の１ページを追加します。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class MakeEvenPage {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java MakeEvenPage in-pdf-file out-pdf-file");
            return;
        }
        
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);
            //ページ数を取得
            int pageCount = doc.getPageCount();
            System.out.println("ページ数："+ pageCount);
            
            if(pageCount % 2 == 0)
            {
                System.out.println("ページ数は偶数です。このままの内容で出力します。");
            }
            else {
                System.out.println("ページ数は奇数です。空白ページを追加して出力します。");
                try (PtlPages pages = doc.getPages();               //ページコンテナの取得
                     PtlPage page = pages.get(0);                   //PDFの先頭ページのページオブジェクトを取得
                     PtlSize sizeOfPage = page.getSize();            //先頭ページのサイズを取得
                     PtlPage blancPage = new PtlPage();              //作成予定のページオブジェクトを作成
                     PtlSize sizeOfBlancPage = blancPage.getSize())  //サイズを取得
                {
                    // 追加する空白ページを作成するために、先頭ページのサイズに合わせます。
                    sizeOfBlancPage.setHeight(sizeOfPage.getHeight());
                    sizeOfBlancPage.setWidth(sizeOfPage.getHeight());
                    
                    // ページの追加
                    pages.append(blancPage, PtlPages.OPTION_NONE);
                }
            }
            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
