/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：ページの移動
  　　　PDF文書の指定したページ範囲を指定した位置に移動します。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class MovePages {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
		if (args.length < 5)
		{
            System.out.println("usage: java MovePages in-pdf-file out-pdf-file move-start-page move-end-page where-to-move");
            System.out.println("move-start-page から move-end-page までの範囲を対象に、where-to-move の後ろへページを移動させます。");
            System.out.println("1ページ目より前へ移動させたい場合は where-to-move に0を指定してください。");
            return;
		}
		int moveStart = Integer.parseInt(args[2]);
		int moveEnd = Integer.parseInt(args[3]);
		if((moveStart < 1)||(moveEnd < 1))
		{
            System.err.println("move-start-page, move-end-pageは正の値を入力してください。");
            return;
		}

		try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument())
		{
            // PDFファイルをロードします。
            doc.load(inputFile);
                    
            int whereToMove = Integer.parseInt(args[4]);
            if((whereToMove < 0)||(whereToMove > doc.getPageCount()))
            {
                System.err.println("where-to-moveは0からPDFのページ数までを指定してください。");
                return;
            }
            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }
			
                        
                //移動ページ数の取得
                int movingPages = moveEnd - moveStart + 1;
                if(movingPages < 1)
                {
                    System.err.println("move-start-pageより小さいmove-end-pageを指定することはできません。");
                    return;
                }

                        
                if((moveStart <= whereToMove) && (whereToMove < moveEnd))
                {
                    System.err.println("where-to-moveは、move-start-pageとmove-end-pageの間で指定することはできません。");
                    return;
                }

                // ページの追加
                if(whereToMove == doc.getPageCount())   //最終ページの後ろに挿入指定の場合
                {
                    pages.move(PtlPages.INSERT_LAST, moveStart - 1, movingPages);
                }
                else    //それ以外
                {
                    // PtlPages.move() のパラメータfromNumは0スタートのため、1引いています。
                    pages.move(whereToMove, moveStart - 1, movingPages);
                }
            }
			// ファイルに保存します。
            doc.save(outputFile);
		}
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
