/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：ページ削除
  　　　PDF文書から指定した範囲のページを削除します。
  　　　※ パラメーターの指定で全ページの削除が出来ますが、
  　　　全てのページを削除したらPDFとしてなりたたないのでエラーとなります。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class RemovePages {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: java RemovePages in-pdf-file out-pdf-file  remove-start-page remove-end-page");
            System.out.println("remove-start-pageに\"0\"を入力した場合、\"全ページの消去\"を実行します。");
            System.out.println("ただし、全てのページを削除したらPDFとして成り立たないため、エラーとなります。");
            return;
        }
        int removeStart = Integer.parseInt(args[2]);
        if(removeStart < 0)
        {
            System.err.println("remove-start-page には0以上の値を入力してください。");
            System.err.println("usage: java RemovePages in-pdf-file out-pdf-file remove-start-page remove-end-page");
            System.err.println("remove-start-pageに\"0\"を入力した場合、\"全ページの消去\"を実行します。");
            System.out.println("ただし、全てのページを削除したらPDFとして成り立たないため、エラーとなります。");
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            // リニアライズ
//            doc.setSaveOption(PtlPDFDocument.SAVE_OPTIONE.SAVE_LINEARIZE);

            // ページ数の取得
            System.out.println("ページ数：" + doc.getPageCount());
			
            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }

                //削除処理
                if(removeStart == 0) //removeAll の指定。
                {
                    pages.removeAll(); // このままsaveするとエラーになります
                }
                else {
                    //削除ページ数の算出
                    int removeEnd = Integer.parseInt(args[3]);
                    int pagesToRemove = removeEnd - removeStart + 1;
                    if(pagesToRemove <= 0)
                    {
                    	System.err.println("remove-end-page は remove-start-page より小さい値は指定できません。");
                        return;
                    }
                    //ページの削除
                    //PtlPages.remove() のパラメータindexは0スタートのため、removeStartから-1しています。
                    pages.remove(removeStart - 1, pagesToRemove);
                }
            }
            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
