/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：A4縦とA4横が混在したPDFの向きを全て横に揃える。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class RotatePage {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: java RotatePage in-pdf-file out-pdf-file 回転方向");
            System.out.println("回転方向:\n 0: 右に回転させて合わせる  1: 左に回転させて合わせる");
            return;
        }
        String rotateDirection = args[2];
        switch (rotateDirection) {
        case "0":
        case "1":
            break;
        default:
            System.err.println("回転方向を正しく指定してください。");
            System.err.println("usage: java RotatePage in-pdf-file out-pdf-file 回転方向");
            System.err.println("回転方向:\n 0: 右に回転させて合わせる  1: 左に回転させて合わせる");
            return;
        }


        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) // ページコンテナの取得
            {
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }
                int numPages = doc.getPageCount();
                for(int i = 0; i < numPages; i++)
                {
                    try (PtlPage page = pages.get(i); //ページオブジェクトの取得
                         PtlSize sizeOfPage = page.getSize()) //ページサイズの取得
                    {
                        float width = sizeOfPage.getWidth();
                        float height = sizeOfPage.getHeight();
                        
                        //回転させるかどうかを判定(仮)
                        //縦の方が横より長いもの（縦長のもの）を回転させる
                        if(height > width)
                        {
                            // 回転角度設定（0, 90, 180, 270）
                            switch (rotateDirection) {
                            case "0":
                                page.setRotate(90);
                                break;
                            case "1":
                                page.setRotate(270);
                                break;
                            }
                        }
                    }
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
