/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：ページ境界値の設定

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import java.io.*;
import jp.co.antenna.ptl.*;

public class SetBoundary {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java SetBoundary in-pdf-file out-pdf-file");
            return;
        }


        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            // ページ数の取得
            int numPages = doc.getPageCount();
            System.out.println("ページ数：" + numPages);

            try (BufferedReader br = new BufferedReader(new InputStreamReader(System.in)))
            {
                int boxType = setBoxType(br);  //Boxの種類を数値で指定するメソッド
                int changingPage = setChangingPage(br);//境界値を変更したいページを指定するメソッド

                if((changingPage < 0)||(numPages < changingPage))
                {
                    System.err.println("変更したいページは正の、全ページ数より少ない値を指定してください。");
                    return ;
                }
                try (PtlPages pages = doc.getPages()) //ページコンテナの取得
                {
                    // ページコンテナが空かどうか
                    if (pages.isEmpty())
                    {
                        System.err.println("ページコンテナが空");
                        return;
                    }
                    // 変更したいページの取得
                    // PtlPages.get() のパラメータindexは0が先頭のため、changingPageから1引いています。
                    try (PtlPage page = pages.get(changingPage -1))
                    {
                        float top, bottom, left,right;
                        System.out.println("変更したい境界値の数値を入力してください。");
                        System.out.print("top (mm) : ");
                        top = Float.parseFloat(br.readLine());
                        System.out.print("bottom (mm) : ");
                        bottom = Float.parseFloat(br.readLine());
                        System.out.print("left (mm) : ");
                        left = Float.parseFloat(br.readLine());
                        System.out.print("right (mm) : ");
                        right = Float.parseFloat(br.readLine());
                            
                        switch(boxType)
                        {
                        case 1://MediaBox
                            try(PtlRect mediaBox = new PtlRect(left, bottom, right, top))
                            {
                                System.out.println(changingPage +"ページ目 MediaBox の[top, bottom, left, right]を、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]に変更します。"); 
                                page.setMediaBox(mediaBox);
                            }
                            break;

                        case 2:  //CropBox
                            try(PtlRect cropBox = new PtlRect(left, bottom, right, top))
                            {
                                System.out.println(changingPage +"ページ目 CropBox の[top, bottom, left, right]を、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]に変更します。"); 
                                page.setCropBox(cropBox);
                            }
                            break;

                        case 3:  //BleedBox
                            try(PtlRect bleedBox = new PtlRect(left, bottom, right, top))
                            {
                                System.out.println(changingPage +"ページ目 BleedBox の[top, bottom, left, right]を、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]に変更します。"); 
                                page.setBleedBox(bleedBox);
                            }
                            
                            break;

                        case 4:  //TrimBox
                            try(PtlRect trimBox = new PtlRect(left, bottom, right, top))
                            {
                                System.out.println(changingPage +"ページ目 TrimBox の[top, bottom, left, right]を、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]に変更します。"); 
                                page.setTrimBox(trimBox);
                            }
                            break;

                        case 5:  //ArtBox
                            try(PtlRect artBox = new PtlRect(left, bottom, right, top))
                            {
                                System.out.println(changingPage +"ページ目 ArtBox の[top, bottom, left, right]を、");
                                System.out.println("[" + top +", " + bottom +", " + left +", " + right +"]に変更します。"); 
                                page.setArtBox(artBox);
                            }
                            break;
                        }
						 
                    }
                    doc.save(outputFile);
                }
            }
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

	public static int setBoxType(BufferedReader br) throws IOException{
		int boxType = 0;
        
		System.out.println("変更したい境界値の種類を数値で指定してください。");
		System.out.println("1: MediaBox, 2: CropBox, 3: BleedBox, 4: TrimBox, 5:ArtBox");
		while((boxType < 1)||(5 < boxType))
		{
			boxType = Integer.parseInt(br.readLine());
			if((boxType < 1) || (5 < boxType))
			{
				System.out.println("数値は1～5の範囲で指定してください。");
			}
		}
		
		return boxType;
	}

	public static int setChangingPage(BufferedReader br) throws IOException{
		int changingPage = 0;

		System.out.println("変更したいページを数値で指定してください。");
		while(changingPage < 1)
		{
			changingPage = Integer.parseInt(br.readLine());
			if(changingPage < 1)
			{
				System.out.println("数値は正の数を指定してください。");
			}
		}
		return changingPage;
	}

}
