/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program
    
  概要：任意のページの拡大縮小

        
  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class ZoomPage {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("usage: java ZoomPage in-pdf-file out-pdf-file page-to-zoom zooming-ratio");
            System.out.println("zooming-ratio : 1.0が等倍です。0.1から10.0までの値を指定してください。");
            return;
        }

        //zooming-ratioの数値判定
        float zoomingRatio = Float.parseFloat(args[3]);
        if((zoomingRatio < 0.1) || (10.0 < zoomingRatio))
        {
            System.err.println("zooming-ratioは0.1から10.0までの値を指定してください。");
            return ;
        }
        
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }

                int numPages = doc.getPageCount();
                System.out.println("ページ数：" + numPages);
                int pageToZoom = Integer.parseInt(args[2]);
                //PageToZoomの値を判定する。
                if((pageToZoom < 1) ||(numPages < pageToZoom))
                {
                    System.err.println("page-to-zoomは、PDFのページ数の範囲で指定してください。");
                    return;
                }
                // ページの取得
                // PtlPages.get() のパラメータindexは0が先頭のため、pageToZoomから1引いています。
                try (PtlPage page = pages.get(pageToZoom - 1)) 
                {
                    page.zoom(zoomingRatio);
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
