﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：暗号化の対象の設定
  　　　文書の全てのコンテンツを暗号化、
  　　　文書のメタデータを除くすべてのコンテンツを暗号化、
  　　　添付ファイルのみ暗号化の３つから選択します。
  　　　暗号化形式は自動的に256 bit AES 暗号化に変換されます。
  　　　全てのユーザアクセス許可フラグは破棄されます。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class EncryptSetEncComponent
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.Write("usage: EncryptSetEncComponent in-pdf-file out-pdf-file ");
                Console.WriteLine("out-pdf-userpass [in-pdf-password]");
                return;
            }

            // コマンドライン引数の取得
            String outUserPass = args[2];

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    if (args.Length > 3)
                    {
                        String password = (String)args[3];
                        // パスワードのセット
                        doc.setPassword(password);
                    }

                    // PDFファイルをロードします。
                    doc.load(inputFile);
                    // 暗号化するコンテンツを選択
                    Console.WriteLine("暗号化するコンテンツを選択します。");
                    Console.WriteLine("暗号化する文書コンポーネントを以下から数値で指定してください。");
                    Console.WriteLine("これ以外の数値が指定された場合は 0 とみなされます。");
                    Console.WriteLine("0 : 文書の全てのコンテンツを暗号化");
                    Console.WriteLine("1 : 文書のメタデータを除く全てのコンテンツを暗号化");
                    Console.WriteLine("2 : 添付ファイルのみを暗号化");
                    int encComponent = int.Parse(Console.ReadLine());

                    Console.WriteLine("256 bit AES で暗号化します。");
                    Console.WriteLine("また、全ての権限情報は破棄されます。");
                    // 暗号化するコンポーネントを変更。
                    encrypt256AESsetEncComponent(doc, outUserPass, encComponent);


                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }


        public static void encrypt256AESsetEncComponent(PtlPDFDocument doc, String outUserPass,
                                                        int encComponent)
        {
            // 256 bit AES
            using (PtlEncryptStandard256AES enc256 = new PtlEncryptStandard256AES())
            {
                switch (encComponent)
                {
                    case 0:
                    default:
                        Console.WriteLine("全てのコンテンツを暗号化します。");
                        enc256.setEncryptComponent(PtlEncrypt.ENCRYPT_COMPONENT.ENCRYPT_ALL);
                        break;
                    case 1:
                        Console.WriteLine("メタデータを除く全てのコンテンツを暗号化します。");
                        enc256.setEncryptComponent(PtlEncrypt.ENCRYPT_COMPONENT.ENCRYPT_EXCEPT_METADATA);
                        break;
                    case 2:
                        Console.WriteLine("添付ファイルのみ暗号化します。");
                        Console.Write("in-pdf-file に添付ファイルが設定されていない場合、");
                        Console.WriteLine("「0 : 全てのコンテンツを暗号化」と同じ処理がなされます。");
                        enc256.setEncryptComponent(PtlEncrypt.ENCRYPT_COMPONENT.ENCRYPT_ONLY_ATTACHED_FILE);
                        break;
                }

                enc256.setUserPassword(outUserPass);
                // 暗号化情報の設定
                doc.setEncrypt(enc256);
            }
        }
    }
}
