﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：しおりの削除

  このサンプルでは下記を行います。
  ・第一階層の最初のしおりのアクションを削除
  ・第一階層の2番目のしおりの子しおりを全てを削除
  ・第一階層の3番目のしおり及びその子しおりを全てを削除
  　　　
  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class RemoveOutline
    {
        /**
     * @param args the command line arguments
     */
        public static void Main(String[] args)
        {
            if (args.Length < 2)
            {
                Console.WriteLine("usage: RemoveOutline in-pdf-file out-pdf-file");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    // アウトラインを持っているかどうか
                    if (!doc.hasOutlines())
                    {
                        Console.WriteLine("アウトラインを持っていない！");
                        return;
                    }

                    using (PtlOutline rootOutline = doc.getRootOutline())
                    {
                        if (rootOutline.hasChild())
                        {
                            using (PtlOutline outline = rootOutline.getFirstChild())
                            { //最初の子アウトラインの取得
                                removeOutline(outline);
                            }
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

        public static void removeOutline(PtlOutline item)
        {
            // 最初の子アウトラインの取得
            Console.WriteLine("- " + item.getTitle());
            // アクションの削除
            Console.WriteLine("「" + item.getTitle() + "」のアクションを削除...");
            item.removeAction();

            // 次の兄弟アウトラインの取得
            using (PtlOutline item2 = item.getNextSibling())
            {
                Console.WriteLine("- " + item2.getTitle());
                // 子アウトラインの削除
                Console.WriteLine("「" + item2.getTitle() + "」の子しおりを削除...");
                item2.removeChildren();

                // 次の兄弟アウトラインの取得
                using (PtlOutline item3 = item2.getNextSibling())
                {
                    Console.WriteLine("- " + item3.getTitle());
                    // 自分自身及び子アウトラインの削除
                    Console.WriteLine("「" + item3.getTitle() + "」と子しおりを削除...");
                    item3.destroy();
                }
            }
        }
    }
}
