/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：しおりの追加
  　　　サンプルPDFにしおり・階層化したしおり・URLにジャンプするしおりを追加します。
  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class AppendOutline {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java AppendOutline in-pdf-file out-pdf-file");
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);
            
            try (PtlOutline outlineRoot = doc.getRootOutline()) { //ルートアウトラインの取得
                // しおりの追加
                createOutline(outlineRoot);
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

    static void createOutline(PtlOutline outlineRoot)
        throws PtlException, Exception, Error {
        try (PtlOutline outlineActionGoToTop = new PtlOutline()) {
            outlineActionGoToTop.setTitle("PDFにしおりを付ける");
            // アクション
            // PtlActionGoTo : GoToアクション<現在のドキュメント内の宛先へ移動>
            try (PtlActionGoTo actionGoTo = new PtlActionGoTo(); 
                 PtlDestFit destFit = new PtlDestFit()) {  // PtlDestFit : Fit型
                // 宛先ページの設定(ページ番号は0ベース)
                destFit.setPageNumber(0);
                // 宛先の設定
                actionGoTo.setDest(destFit);
                // アクションの設定
                outlineActionGoToTop.setAction(actionGoTo);
            }
            // アウトラインタイトルの色を設定
            try (PtlColorDeviceRGB color =  new PtlColorDeviceRGB(1.0f, 0.0f, 0.0f)) {
                outlineActionGoToTop.setColor(color);
            }
            // アウトラインフラグを設定 (FLAG_BOLD : 太字)
            outlineActionGoToTop.setFlags(PtlOutline.FLAG_BOLD);
            // PDF表示時の子アウトラインをオープンするかどうかの設定

            outlineActionGoToTop.setOpen(true);
            // 子アウトラインの追加
            outlineRoot.appendLastChild(outlineActionGoToTop);

            try (PtlOutline outlineActionGoTo2 = new PtlOutline()) {
                outlineActionGoTo2.setTitle("Bookmark sample-1");
                // アクション
                // PtlActionGoTo : GoToアクション<現在のドキュメント内の宛先へ移動>
                try (PtlActionGoTo actionGoTo2 = new PtlActionGoTo(); 
                     PtlDestFitH destFitH = new PtlDestFitH()) { // PtlDestFitH : FitH型
                    // 宛先ページの設定(ページ番号は0ベース)
                    destFitH.setPageNumber(1);
                    // topの設定(本文の文章がちょうど一番上に来るように調整)
                    destFitH.setTop(245);
                    // 宛先の設定
                    actionGoTo2.setDest(destFitH);
                    // アクションの設定
                    outlineActionGoTo2.setAction(actionGoTo2);
                }
                // アウトラインタイトルの色を設定
                try (PtlColorDeviceRGB color =  new PtlColorDeviceRGB(0.0f, 0.5f, 0.0f)) {
                    outlineActionGoTo2.setColor(color);
                }
                // アウトラインフラグを設定（FLAG_NORMAL : ノーマル）
                outlineActionGoTo2.setFlags(PtlOutline.FLAG_NORMAL);
                // PDF表示時の子アウトラインをオープンするかどうかの設定
                outlineActionGoTo2.setOpen(false);
                // 子アウトラインの追加
                outlineActionGoToTop.appendLastChild(outlineActionGoTo2);

                // URIアクション    -----------------------------------
                try (PtlOutline outlineActionURI = new PtlOutline()) {
                    // アウトラインタイトル文字列を設定
                    outlineActionURI.setTitle("http://www.antenna.co.jp/");
                    // アクション
                    // PtlActionURI : URIアクション
                    try (PtlActionURI actionuri = new PtlActionURI()) {
                        // URIを設定
                        actionuri.setURI("http://www.antenna.co.jp/");
                        // アクションの設定
                        outlineActionURI.setAction(actionuri);
                    }
                    // アウトラインタイトルの色を設定
                    try (PtlColorDeviceRGB color =  new PtlColorDeviceRGB(0.0f, 0.0f, 1.0f)) {
                        outlineActionURI.setColor(color);
                    }
                    // アウトラインフラグを設定
                    // (FLAG_BOLD : 太字　と、　FLAG_ITALIC : イタリック　の論理和)
                    outlineActionURI.setFlags(PtlOutline.FLAG_BOLD | PtlOutline.FLAG_ITALIC);
                    // PDF表示時の子アウトラインをオープンするかどうかの設定
                    // （false : 新ウィンドウでオープンしない）
                    outlineActionURI.setOpen(false);
                    // Bookmark sample-1の兄弟アウトラインとして追加
                    outlineActionGoTo2.appendNextSibling(outlineActionURI);
                }
            }
        }
    }
}
