/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：しおりの削除

  このサンプルでは下記を行います。
  ・第一階層の最初のしおりのアクションを削除
  ・第一階層の2番目のしおりの子しおりを全てを削除
  ・第一階層の3番目のしおり及びその子しおりを全てを削除
  　　　
  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class RemoveOutline {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java RemoveOutline in-pdf-file out-pdf-file");
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            // アウトラインを持っているかどうか
            if (!doc.hasOutlines()) {
                System.out.println("このPDFにはアウトラインがありません。");
                return;
            }

            try (PtlOutline rootOutline = doc.getRootOutline()) {
                if (rootOutline.hasChild()) {
                    try (PtlOutline outline = rootOutline.getFirstChild()) { //最初の子アウトラインの取得
                        removeOutline(outline);
                    }
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
             System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                                "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

    static void removeOutline(PtlOutline item) throws PtlException, Exception, Error {
        // 最初の子アウトラインの取得
        System.out.println("- " + item.getTitle());
        // アクションの削除
        System.out.println("「" + item.getTitle() + "」のアクションを削除...");
        item.removeAction();

        // 次の兄弟アウトラインの取得
        try (PtlOutline item2 = item.getNextSibling()) {
            System.out.println("- " + item2.getTitle());
            // 子アウトラインの削除
            System.out.println("「" + item2.getTitle() + "」の子しおりを削除...");
            item2.removeChildren();

            // 次の兄弟アウトラインの取得
            try (PtlOutline item3 = item2.getNextSibling()) {
                System.out.println("- " + item3.getTitle());
                // 自分自身及び子アウトラインの削除
                System.out.println("「" + item3.getTitle() + "」と子しおりを削除...");
                item3.destroy();
            }
        }
    }
}
