﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：画像個数の取得
  　　　PDFページ毎に画像エレメントの個数を取得して一覧を出力する。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class CountImage
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: CountImage in-pdf-file");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 1)
            {
                printUsage();
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    using (PtlPages pages = doc.getPages())
                    { // ページコンテナの取得
                      // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        // ページ数を取得
                        int wholePageNum = doc.getPageCount();
                        Console.WriteLine("このPDFに含まれる画像の数をページごとに表示します。");
                        // 各ページの取得(index番号は0が先頭のためi=0からスタートさせる)
                        for (int i = 0; i < wholePageNum; i++)
                        {
                            using (PtlPage page = pages.get(i))
                            {
                                // 画像抽出
                                countImage(page, i + 1);
                            }
                        }
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

        public static void countImage(PtlPage page, int pageNum)
        {
            // ページコンテント及びそのページコンテントの画像エレメントの取得
            using (PtlContent content = page.getContent())
            using (PtlEditElements elems = content.getEditElements(PtlContent.GET_ELEMENT.GET_IMAGE))
            {
                Console.Write(string.Format("{0,4}ページ目 … 画像の数：{1,3}個\n",
                                  pageNum, elems.getCount()));
            }
        }
    }
}
