/*
  Antenna House PDF Tool API V6.0
  Java Interface sample program

  概要：画像個数の取得
  　　　PDFページ毎に画像エレメントの個数を取得して一覧を出力する。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class CountImage {
    
    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java CountImage in-pdf-file");
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            printUsage();
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) { // ページコンテナの取得 
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.out.println("ページコンテナが空");
                    return;
                }

                // ページ数を取得
                int wholePageNum = doc.getPageCount();
                System.out.println("このPDFに含まれる画像の数をページごとに表示します。");
                // 各ページの取得(index番号は0が先頭のためi=0からスタートさせる)
                for(int i = 0; i < wholePageNum; i++) {
                    try (PtlPage page = pages.get(i)) {
                        // 画像抽出
                        countImage(page, i+1);
                    }
                }
            }
        }
        catch (PtlException pex) {
             System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                                "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

    public static void countImage(PtlPage page, int pageNum)
        throws PtlException, Exception, Error {
        // ページコンテント及びそのページコンテントの画像エレメントの取得
        try (PtlContent content = page.getContent();
             PtlEditElements elems = content.getEditElements(PtlContent.GET_IMAGE)) {
            System.out.printf("%4dページ目 … 画像の数：%3d個\n",
                              pageNum, elems.getCount());
        }
    }
    
}
