﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：文書情報の取得

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class GetDocInfo
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: GetDocInfo in-pdf-file");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 1)
            {
                printUsage();
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    using (PtlDocProperty docProperty = doc.getDocProperty())   //PDFの文書プロパティ
                    using (PtlDocInfo docinf = docProperty.getDocInfo())        //PDFの文書情報
                                                                                // PDFのカスタムプロパティ
                    using (PtlCustomProperties customProperties = docProperty.getCustomProperties())
                    {
                        // タイトル取得
                        Console.WriteLine("Title : " + docinf.getTitle());
                        // 著者取得
                        Console.WriteLine("Author : " + docinf.getAuthor());
                        // サブジェクト取得
                        Console.WriteLine("Subject : " + docinf.getSubject());
                        // キーワード取得
                        Console.WriteLine("Keywords : " + docinf.getKeywords());
                        // クリエータ取得
                        Console.WriteLine("Creator : " + docinf.getCreator());
                        // プロデューサ取得
                        Console.WriteLine("Producer : " + docinf.getProducer());
                        // 作成日付を取得
                        using (PtlDate dateCreate = docinf.getCreationDate())
                        {
                            Console.WriteLine("CreationDate : "
                                + dateCreate.getYear()
                                + "/" + dateCreate.getMonth()
                                + "/" + dateCreate.getDay()
                                + " " + dateCreate.getHour()
                                + ":" + dateCreate.getMin()
                                + ":" + dateCreate.getSec());
                        }

                        // 更新日付を取得
                        using (PtlDate dateMod = docinf.getModDate())
                        {
                            Console.WriteLine("ModDate : "
                                + dateMod.getYear()
                                + "/" + dateMod.getMonth()
                                + "/" + dateMod.getDay()
                                + " " + dateMod.getHour()
                                + ":" + dateMod.getMin()
                                + ":" + dateMod.getSec());
                        }

                        // カスタムプロパティが空かどうか判定
                        Console.WriteLine("");
                        if (customProperties.isEmpty())
                        {
                            //空の場合はそう表示する
                            Console.WriteLine("このPDFにカスタムプロパティは設定されていません。");
                        }
                        else
                        {  // カスタムプロパティが空でない場合に内容を取得する
                            Console.WriteLine("このPDFのカスタムプロパティを表示します。");
                            int propertiesNum = customProperties.getCount();
                            for (int i = 0; i < propertiesNum; i++)
                            {
                                Console.WriteLine("Custom Property No." + (i + 1) + ":");
                                using (PtlCustomProperty customProperty = customProperties.get(i))
                                {
                                    Console.WriteLine("名前 : " + customProperty.getName());
                                    Console.WriteLine("値 : " + customProperty.getValue());
                                    Console.WriteLine("");
                                }
                            }
                        }
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
