﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：添付ファイルの情報を表示する。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class GetEmbedFileInfo
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: GetEmbedFileInfo in-pdf-file");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 1)
            {
                printUsage();
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    // 添付ファイルコンテナの取得
                    using (PtlEmbeddedFiles embeddedFiles = doc.getEmbeddedFiles())
                    {
                        // 添付ファイルコンテナが空かどうか
                        if (embeddedFiles.isEmpty())
                        {
                            Console.WriteLine("添付ファイルコンテナは空");
                            return;
                        }
                        // 添付ファイル数の取得
                        int numOfEmbeddedFile = embeddedFiles.getCount();
                        Console.WriteLine("添付ファイル数 : " + numOfEmbeddedFile);

                        for (int i = 0; i < numOfEmbeddedFile; i++)
                        {
                            using (PtlEmbeddedFile embeddedfile = embeddedFiles.get(i))
                            {
                                Console.WriteLine("index num : " + i +
                                                   " の添付ファイル名 : " +
                                                   embeddedfile.getFileName());

                            }
                        }
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

    }
}
