﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：画像ファイルのPDF化

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class ImageToPdf
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: ImageToPdf image-file out-pdf-file");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 2)
            {
                printUsage();
                return;
            }

            try
            {  //作成したクラスのページコンテナの取得

                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())  //PDF文書を表現したクラスを新規作成
                using (PtlPages pages = doc.getPages())
                {
                    // 画像描画パラメータ
                    // 画像ファイル
                    // 画像ページパラメータ の取得
                    using (PtlParamDrawImage paramDrawImage = new PtlParamDrawImage())
                    using (PtlParamInput inputImage = new PtlParamInput(args[0]))
                    using (PtlParamImagePage paramImagePage = new PtlParamImagePage())
                    {
                        // 画像描画パラメータに画像ファイルを設定
                        paramDrawImage.setImageStream(inputImage);

                        // 画像ページパラメータに画像描画パラメータを設定
                        paramImagePage.setImage(paramDrawImage);

                        // 画像ページのサイズを画像サイズにあわせる
                        paramImagePage.setPaperType(PtlParamImagePage.PAPER_TYPE.PAPER_IMAGE_SIZE);

                        // 画像の配置を設定
                        paramImagePage.setAlign(PtlParamImagePage.ALIGN.ALIGN_CENTER);

                        // ページコンテナに画像ページパラメータを追加
                        pages.append(paramImagePage);
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

    }
}
