﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：画像ファイルのPDF化(PDFの用紙の大きさ・用紙タイプの指定)

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class ImageToPdfSetPaperType
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: ImageToPdfSetPaperType image-file" +
                               " out-pdf-file paper-type");
            Console.WriteLine("paper-type : 用紙タイプ");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 2)
            {
                printUsage();
                return;
            }

            //コマンドライン引数の読み取り
            String paperType = args[2];
            try
            {
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())  //PDF文書を表現したクラスを新規作成
                using (PtlPages pages = doc.getPages()) //作成したクラスのページコンテナの取得
                {
                    // 画像描画パラメータ
                    // 画像ファイル
                    // 画像ページパラメータ の取得
                    try
                    {
                        using (PtlParamDrawImage paramDrawImage = new PtlParamDrawImage())
                        using (PtlParamInput inputImage = new PtlParamInput(args[0]))
                        using (PtlParamImagePage paramImagePage = new PtlParamImagePage())
                        {
                            // 画像描画パラメータに画像ファイルを設定
                            paramDrawImage.setImageStream(inputImage);

                            // 画像ページパラメータに画像描画パラメータを設定
                            paramImagePage.setImage(paramDrawImage);

                            // 画像ページのサイズを画像サイズにあわせる
                            paramImagePage.setPaperType(
                                (PtlParamImagePage.PAPER_TYPE)Enum.Parse(typeof(PtlParamImagePage.PAPER_TYPE), paperType));

                            // 画像の配置を設定
                            paramImagePage.setAlign(PtlParamImagePage.ALIGN.ALIGN_CENTER);

                            // ページコンテナに画像ページパラメータを追加
                            pages.append(paramImagePage);
                        }
                    }
                    //PtlParamImagePage.PAPER_TYPEの指定が誤っていた場合のエラーメッセージ
                    catch (ArgumentException iaex)
                    {
                        Console.WriteLine(iaex.Message);
                        Console.WriteLine("ERROR : paper-typeにはPtlParamImagePage.PAPER_TYPEに" +
                                           "含まれる名前を指定してください。");
                        Console.WriteLine(iaex.StackTrace);
                    }
                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
