﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：カスタムプロパティの削除
  　　　削除するカスタムプロパティを番号で指定して、削除します。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class RemoveCustomDocProperty
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: RemoveCustomDocProperty in-pdf-file out-pdf-file" +
                               " num-of-custom-prop");
            Console.WriteLine("num-of-custom-prop : ");
            Console.WriteLine("0 : カスタムプロパティを全削除");
            Console.WriteLine(" 0以外の数値 : n番目に入っているカスタムプロパティを削除");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                printUsage();
                return;
            }


            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    using (PtlDocProperty docProperty = doc.getDocProperty()) //PDFの文書プロパティ
                    using (PtlCustomProperties customProperties = docProperty.getCustomProperties())
                    {
                        // コマンドライン引数の指定と判定
                        int numToRemoveCustomProp = int.Parse(args[2]);
                        if (customProperties.getCount() < numToRemoveCustomProp)
                        {
                            Console.WriteLine("num-of-custom-prop はカスタムプロパティ数" +
                                               "より小さい値を指定してください。");
                            return;
                        }
                        // カスタムプロパティを削除
                        // 0のときは全て削除
                        if (numToRemoveCustomProp == 0)
                        {
                            customProperties.removeAll();
                        }
                        else
                        {
                            // 指定カスタムプロパティを削除
                            // (パラメータindexは0が先頭のため1を引く)
                            customProperties.remove(numToRemoveCustomProp - 1);
                        }

                    }
                    // ファイルに保存します
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
