﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：増分更新形式で保存する。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class SaveByIncrementalUpdate
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.Write("usage: SaveByIncrementalUpdate in-pdf-file out-pdf-file");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 2)
            {
                printUsage();
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    // 増分更新
                    doc.setSaveOption(PtlPDFDocument.SAVE_OPTION.SAVE_INCREMENTAL_UPDATE);
                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        using (PtlPage page = pages.get(0))// ページの取得（先頭ページを指定）
                        using (PtlContent content = page.getContent())// ページコンテントの取得
                        using (PtlRect outputRect = new PtlRect())// 出力矩形の設定
                        using (PtlParamFont font = new PtlParamFont())// フォント
                                                                      // 文字描画のパラメータクラス。今回は何も設定しない。
                        using (PtlParamWriteString writeStringParam = new PtlParamWriteString())
                        {

                            setRect(outputRect, 130, 58, 200, 65);
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_BOTTOM_LEFT,
                                                "this is test message",
                                                writeStringParam);
                        }
                    }
                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

        public static PtlRect setRect(PtlRect outputRect, float left, float bottom,
                                      float right, float top)
        {
            outputRect.setLeft(left);
            outputRect.setBottom(bottom);
            outputRect.setRight(right);
            outputRect.setTop(top);

            return outputRect;
        }
    }
}
