﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：各種座標系オプションを切り替えて、文字列の表示が変化するようにします。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;


namespace cookbook
{
    public class SetCoordinateOriginAndUnit
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: SetCoordinateOriginAndUnit input-pdf-file" +
                               " out-pdf-file 原点の位置 座標の単位");
            Console.WriteLine("原点の位置 : ");
            Console.WriteLine("0: 	左下(デフォルト値) 　1: 左上");
            Console.WriteLine("座標の単位 : ");
            Console.WriteLine("0: mm(デフォルト値)　" +
                               "1: ポイント");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 4)
            {
                printUsage();
                return;
            }

            //コマンドライン引数の読み取り
            int originType = int.Parse(args[2]);
            int unitType = int.Parse(args[3]);

            // コマンドライン引数の判定
            if ((originType < 0) || (1 < originType))
            {
                Console.WriteLine("原点の位置 は0か1で指定して下さい。");
                printUsage();
                return;
            }

            if ((unitType < 0) || (1 < unitType))
            {
                Console.WriteLine("座標の単位 は0か1で指定して下さい。");
                printUsage();
                return;
            }

            try {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                using (PtlOption coordOption = new PtlOption())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    // 原点の位置の指定
                    switch (originType)
                    {
                        case 0: //左下(デフォルト値)
                            coordOption.setOrigin(PtlOption.ORIGIN.ORIGIN_BOTTOM_LEFT);
                            break;
                        case 1: // 左上
                            coordOption.setOrigin(PtlOption.ORIGIN.ORIGIN_TOP_LEFT);
                            break;
                    }

                    // 原点の単位の指定
                    switch (unitType)
                    {
                        case 0: //mm(デフォルト値)
                            coordOption.setUnit(PtlOption.UNIT.UNIT_MM);
                            break;
                        case 1: // PT
                            coordOption.setUnit(PtlOption.UNIT.UNIT_PT);
                            break;
                    }


                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        // ページの取得(パラメータindexは0が先頭のため1を引く)
                        // ページコンテントの取得
                        // 直線の始点を(50,50)で指定
                        // 直線の終点を(100, 100)で指定
                        // 文字描画のパラメータクラス。今回は何も設定しない。
                        using (PtlPage page = pages.get(0))
                        using (PtlContent content = page.getContent())
                        using (PtlPoint point5050 = new PtlPoint(50, 50))
                        using (PtlPoint point100100 = new PtlPoint(100, 100))
                        using (PtlParamDrawShape paramDrawShape = new PtlParamDrawShape())
                        {
                            // 直線を描画
                            content.drawLine(point5050, point100100, paramDrawShape);
                        }

                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
        catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
