﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：文書情報の設定

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using PdfTkNet;
using System;

namespace cookbook
{
    public class SetDocInfo
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: SetDocInfo in-pdf-file out-pdf-file" +
                               " タイトル 作者 " +
                               " 作成年 作成月 作成日 作成時 作成分");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 9)
            {
                printUsage();
                return;
            }


            String title = args[2];
            String author = args[3];
            int createYear = int.Parse(args[4]);
            int createMonth = int.Parse(args[5]);
            int createDay = int.Parse(args[6]);
            int createHour = int.Parse(args[7]);
            int createMinute = int.Parse(args[8]);
            int createSecond = 0; //分までの入力にし、秒は０にする。

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    using (PtlDocProperty docProperty = doc.getDocProperty()) // PDFの文書プロパティ
                    using (PtlDocInfo docinf = docProperty.getDocInfo())
                    {    // PDFの文書情報

                        // タイトルを設定
                        docinf.setTitle(title);
                        // 著者を設定
                        docinf.setAuthor(author);

                        // 作成日付を設定
                        using (PtlDate dateCreateNew = new PtlDate(createYear,
                                                                 createMonth,
                                                                 createDay,
                                                                 createHour,
                                                                 createMinute,
                                                                 createSecond))
                        {
                            docinf.setCreationDate(dateCreateNew);
                        }

                        // 更新日付を設定(更新時の時間で作成)
                        DateTime timeNow = DateTime.Now;
                        using (PtlDate dateModNew = new PtlDate(timeNow.Year,
                                                          timeNow.Month,
                                                          timeNow.Day,
                                                          timeNow.Hour,
                                                          timeNow.Minute,
                                                          timeNow.Second))
                        {
                            docinf.setModDate(dateModNew);
                        }
                    }

                    // ファイルに保存します
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
