﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：開き方の設定(ページ関連の設定)

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace cookbook
{
    public class SetOpenAction
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.Write("usage: SetOpenAction in-pdf-file out-pdf-file");
            Console.WriteLine(" ページ表示の種類 開くページ [top left bottom right zoom]");
            Console.WriteLine("ページ表示の種類: ");
            Console.WriteLine("0 : Fit型 ページ全体がウィンドウに収まるように表示する");
            Console.WriteLine("1 : FitB型 境界ボックス全体がウィンドウに収まるように表示する");
            Console.WriteLine("2 : FitBH型 topを指定し、" +
                               "境界ボックスの幅がウィンドウに収まるように表示する");
            Console.WriteLine("3 : FitBV型 leftを指定し、" +
                               "境界ボックスの高さがウィンドウに収まるように表示する");
            Console.WriteLine("4 : FitH型 topを指定し、" +
                               "ページの幅がウィンドウに収まるように表示する");
            Console.WriteLine("5 : FitR型 top, left, bottom, rightを指定し、" +
                               "指定した範囲がウィンドウに収まるように表示する");
            Console.WriteLine("6 : FitV型 leftを指定し、" +
                               "ページの幅がウィンドウに収まるように表示する");
            Console.WriteLine("7 : XYZ型 top, left, zoomを指定し、" +
                               "ウィンドウ左上が指定したページ座標になるようにして" +
                               "指定したzoom率で表示する");
            Console.WriteLine("※ : top, left, bottom, right, zoomに関しては" +
                               "ページ表示の種類によって不要な項目は読み飛ばされます。");
            Console.WriteLine("例えば、FitV型を指定してleftの値だけを指定する場合は" +
                               "topから順に\"0 15\"、XYZ型を指定してzoomの値を設定する場合は" +
                               "topから順に \"100 15 0 0 1.2\"のように" +
                               "読み飛ばす部分に仮の値を挿入してください。）");
        }

        /**
         * @param args the command line arguments
         */
        public static void Main(String[] args)
        {
            if (args.Length < 4)
            {
                printUsage();
                return;
            }
            // コマンドライン引数の読み取り
            int page = int.Parse(args[3]);
            float top = float.Parse(args[4]);
            float left = float.Parse(args[5]);
            float bottom = float.Parse(args[6]);
            float right = float.Parse(args[7]);
            float zoom = float.Parse(args[8]);

            //ページ表示の種類が誤った数値だった場合に停止する。
            int destType = int.Parse(args[2]);
            if (destType < 0 || 7 < destType)
            {
                Console.WriteLine("ページ表示の種類は0～7の数値で指定して下さい。");
                printUsage();
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    using (PtlDocProperty docProperty = doc.getDocProperty())   // PDFの文書プロパティ
                    using (PtlOpenMode openmode = docProperty.getOpenMode())    // 開き方の取得
                    {

                        // ページモードの設定 ページレイアウトの設定
                        // 各オープンアクションの設定
                        if (destType == 0) //Fit型
                        {
                            using (PtlActionGoTo act = new PtlActionGoTo()) // 設定するGoToアクション
                            using (PtlDestFit dst = new PtlDestFit())       // PDFの宛先
                            {
                                // 宛先ページの設定
                                // 最初に開くページを設定（ページ番号は0ベース）
                                dst.setPageNumber(page);
                                // 宛先をGoToActionに設定
                                act.setDest(dst);
                                openmode.setOpenAction(act);
                            }
                        }
                        if (destType == 1) //FitB型
                        {
                            using (PtlActionGoTo act = new PtlActionGoTo()) // 設定するGoToアクション
                            using (PtlDestFitB dst = new PtlDestFitB())     // PDFの宛先
                            {
                                // 宛先ページの設定
                                // 最初に開くページを設定（ページ番号は0ベース）
                                dst.setPageNumber(page);
                                // 宛先をGoToActionに設定
                                act.setDest(dst);
                                openmode.setOpenAction(act);
                            }
                        }
                        if (destType == 2) //FitBH型
                        {
                            using (PtlActionGoTo act = new PtlActionGoTo()) // 設定するGoToアクション
                            using (PtlDestFitBH dst = new PtlDestFitBH())   // PDFの宛先
                            {
                                // 宛先ページの設定
                                // 最初に開くページを設定（ページ番号は0ベース）
                                dst.setPageNumber(page);
                                // 開く座標の設定
                                // topの設定
                                dst.setTop(top);
                                // 宛先をGoToActionに設定
                                act.setDest(dst);
                                openmode.setOpenAction(act);
                            }
                        }
                        if (destType == 3) //FitBV型
                        {
                            using (PtlActionGoTo act = new PtlActionGoTo()) // 設定するGoToアクション
                            using (PtlDestFitBV dst = new PtlDestFitBV())   // PDFの宛先
                            {
                                // 宛先ページの設定
                                // 最初に開くページを設定（ページ番号は0ベース）
                                dst.setPageNumber(page);
                                // 開く座標の設定
                                // leftの設定
                                dst.setLeft(left);
                                // 宛先をGoToActionに設定
                                act.setDest(dst);
                                openmode.setOpenAction(act);
                            }
                        }
                        if (destType == 4) //FitH型
                        {
                            using (PtlActionGoTo act = new PtlActionGoTo()) // 設定するGoToアクション
                            using (PtlDestFitH dst = new PtlDestFitH())     // PDFの宛先
                            {
                                // 宛先ページの設定
                                // 最初に開くページを設定（ページ番号は0ベース）
                                dst.setPageNumber(page);
                                // 開く座標の設定
                                // topの設定
                                dst.setTop(top);
                                // 宛先をGoToActionに設定
                                act.setDest(dst);
                                openmode.setOpenAction(act);
                            }
                        }
                        if (destType == 5) //FitR型
                        {
                            using (PtlActionGoTo act = new PtlActionGoTo()) // 設定するGoToアクション
                            using (PtlDestFitR dst = new PtlDestFitR())     // PDFの宛先
                            {
                                // 宛先ページの設定
                                // 最初に開くページを設定（ページ番号は0ベース）
                                dst.setPageNumber(page);
                                // 開く座標の設定
                                // topの設定
                                dst.setTop(top);
                                // leftの設定
                                dst.setLeft(left);
                                // bottomの設定
                                dst.setBottom(bottom);
                                // rightの設定
                                dst.setRight(right);
                                // 宛先をGoToActionに設定
                                act.setDest(dst);
                                openmode.setOpenAction(act);
                            }
                        }
                        if (destType == 6) //FitV型
                        {
                            using (PtlActionGoTo act = new PtlActionGoTo()) // 設定するGoToアクション
                            using (PtlDestFitV dst = new PtlDestFitV())     // PDFの宛先
                            {
                                // 宛先ページの設定
                                // 最初に開くページを設定（ページ番号は0ベース）
                                dst.setPageNumber(page);
                                // 開く座標の設定
                                // leftの設定
                                dst.setLeft(left);
                                // 宛先をGoToActionに設定
                                act.setDest(dst);
                                openmode.setOpenAction(act);
                            }
                        }
                        if (destType == 7) //XYZ型
                        {
                            using (PtlActionGoTo act = new PtlActionGoTo()) // 設定するGoToアクション
                            using (PtlDestXYZ dst = new PtlDestXYZ())       // PDFの宛先
                            {
                                // 宛先ページの設定
                                // 最初に開くページを設定（ページ番号は0ベース）
                                dst.setPageNumber(page);
                                // 開く座標の設定
                                // leftの設定
                                dst.setLeft(left);
                                // topの設定
                                dst.setTop(top);
                                //dst.setTopNull();
                                // zoomの設定
                                dst.setZoom(zoom);
                                //dst.setZoomNull();
                                // 宛先をGoToActionに設定
                                act.setDest(dst);
                                openmode.setOpenAction(act);
                            }
                        }
                        /*----- 開き方のデフォルト設定 -----*/
                        // ページモードの設定 PAGE_MODE_USE_THUMBS = 3  サムネイルパネルとページ
                        openmode.setPageMode(PtlOpenMode.PAGE_MODE.PAGE_MODE_USE_THUMBS);

                        // ページレイアウトの設定 PAGE_LAYOUT_ONE_COLUMN = 2 /* 連続ページ */
                        openmode.setPageLayout(PtlOpenMode.PAGE_LAYOUT.PAGE_LAYOUT_ONE_COLUMN);
                        // ユーザーインターフェイスオプションを設定（論理和）
                        // UI_OPTION_HIDE_WINDOWUI = 0x00000004
                        /* ウインドウコントロールを非表示 */
                        openmode.setUIOption(PtlOpenMode.UI_OPTION.UI_OPTION_HIDE_WINDOWUI);

                        // ウインドウオプションを設定（論理和）
                        // WINDOWS_OPTION_FIT_WINDOW = 0x00000001,
                        /* ページにウィンドウサイズを合あわせる */
                        // WINDOWS_OPTION_CENTER_WINDOW = 0x00000002,
                        /* ウィンドウを画面中央に配置 */
                        openmode.setWindowOption(PtlOpenMode.WINDOWS_OPTION.WINDOWS_OPTION_FIT_WINDOW
                            | PtlOpenMode.WINDOWS_OPTION.WINDOWS_OPTION_CENTER_WINDOW);

                        // ウィンドウのタイトルバーに文書タイトルを表示するかどうか設定
                        //（true: 非表示、false: 表示）
                        openmode.setDisplayDocTitle(true);

                        // 読み上げオプション設定 DIRECTION_R2L = 2
                        /* 右から左(中国語、日本語、韓国語のような縦書きも含む)    */
                        docProperty.setDirection(PtlDocProperty.DIRECTION.DIRECTION_R2L);
                        /*----- 以上、ここまでが開き方のデフォルト設定 -----*/

                    }
                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() +
                                   "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }

        }
    }
}