/*
  Antenna House PDF Tool API V6.0
  Java Interface sample program

  概要：ファイルの添付

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class AppendEmbeddedFile {

    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java AppendEmbeddedFile in-pdf-file" +
                           " out-pdf-file file-to-embed embedded-file-name");
     }



    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            printUsage();
            return;
        }


        // コマンドライン引数の読み取り
        String embeddedFileName = args[3];

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {

            // PDFファイルをロード
            doc.load(inputFile);
            
            // 添付ファイルコンテナの取得
            try (PtlEmbeddedFiles embeddedfiles = doc.getEmbeddedFiles();
                 // 添付するファイルの取得と添付ファイル用クラスの取得
                 PtlEmbeddedFile embeddedfile = new PtlEmbeddedFile();
                 PtlParamInput inputEmbed = new PtlParamInput(args[2])) {
                // 添付ファイル数の取得
                System.out.println("追加前の添付ファイル数 : " + embeddedfiles.getCount());

                // 添付ファイル名の設定
                embeddedfile.setFileName(embeddedFileName);
                // 添付するファイルの読み込み
                embeddedfile.readFile(inputEmbed);

                // 添付ファイルの追加
                embeddedfiles.append(embeddedfile);
                // 添付ファイル数の取得
                System.out.println("追加後の添付ファイル数 : " +
                                   embeddedfiles.getCount());
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
