/*
  Antenna House PDF Tool API V6.0
  Java Interface sample program

  概要：指定したタイプのインテリアカラーを一括で変更する。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class ChangeAnnotsInteriorColor {
    // そのクラスのusageを表示する関数
    private static void printUsage() {
            System.out.println("usage: java ChangeAnnotsInteriorColor in-pdf-file" +
                               " out-pdf-file 色変更の注釈種類" +
                               " interior-color-R interior-color-G interior-color-B");
            System.out.println("色変更の注釈種類");
            System.out.println("0 : FreeText  1 : Line  2 : Square" +
                               "  3 : Circle  4 : PolyLine 5 : Polygon");
    }



    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            printUsage();
            return;
        }

        // 色変更の注釈種類
        int annotKindNum = Integer.parseInt(args[2]);
        PtlAnnot.ANNOT_TYPE annotKind;
        switch (annotKindNum) {
        case 0:
            annotKind = PtlAnnot.ANNOT_TYPE.TYPE_FREE_TEXT;
            break;
        case 1:
            annotKind = PtlAnnot.ANNOT_TYPE.TYPE_LINE;
            break;
        case 2:
            annotKind = PtlAnnot.ANNOT_TYPE.TYPE_SQUARE;
            break;
        case 3:
            annotKind = PtlAnnot.ANNOT_TYPE.TYPE_CIRCLE;
            break;
        case 4:
            annotKind = PtlAnnot.ANNOT_TYPE.TYPE_POLYLINE;
            break;
        case 5:
            annotKind = PtlAnnot.ANNOT_TYPE.TYPE_POLYGON;
            break;
        default:
            printUsage();
            return;
        }
        // コマンドライン引数の読み取り
        float colorR = Float.parseFloat(args[3]);
        float colorG = Float.parseFloat(args[4]);
        float colorB = Float.parseFloat(args[5]);


        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {

            // PDFファイルをロードします。
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) { //ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.out.println("ページコンテナが空\n");
                    return;
                }

                int numPages = pages.getCount();
                for(int i=0; i<numPages; i++) {
                    System.out.println("ページ" + (i+1));

                    try (PtlPage page = pages.get(i)) {
                        // 注釈コンテナが空かどうか
                        if (!page.hasAnnots()) {
                            System.out.println("注釈なし");
                            continue;
                        }

                        try (PtlAnnots annots = page.getAnnots()) {
                            // 注釈数の取得
                            int numAnnots = annots.getCount();
                            System.out.println("注釈数 : " + numAnnots);
                            for(int j=0; j<numAnnots; j++) {
                                try (PtlAnnot annot = annots.get(j)) {
                                    if(annot.getType() == annotKind){
                                        changeAnnotInteriorColor(annot,
                                                                 colorR, colorG, colorB);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

    public static void changeAnnotInteriorColor(PtlAnnot annot,
                                                float colorR, float colorG, float colorB)
        throws PtlException, Exception, Error {
        try (PtlColorDeviceRGB color = new PtlColorDeviceRGB(colorR, colorG, colorB))
        {
            annot.setInteriorColor(color);
        }
    }
}
