/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：画像ファイルのPDF化(余白の設定)

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class ImageToPdfSetMargin {

    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java ImageToPdfSetMargin image-file" +
                           " out-pdf-file marginTop marginLeft marginBottom marginRight");
     }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 6) {
            printUsage();
            return;
        }

        // コマンドライン引数の取得 
        float marginTop    = Float.parseFloat(args[2]);
        float marginLeft   = Float.parseFloat(args[3]);
        float marginBottom = Float.parseFloat(args[4]);
        float marginRight  = Float.parseFloat(args[5]);
        try (PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument();  //PDF文書を表現したクラスを新規作成
             PtlPages pages = doc.getPages()) {  //作成したクラスのページコンテナの取得

            // 画像描画パラメータ
            // 画像ファイル
            // 画像ページパラメータ の取得
            try (PtlParamDrawImage paramDrawImage = new PtlParamDrawImage();
                 PtlParamInput inputImage = new PtlParamInput(args[0]);
                 PtlParamImagePage paramImagePage = new PtlParamImagePage()) {
                // 画像の余白を設定
                paramImagePage.setMargin(marginTop, marginLeft, marginBottom, marginRight);

                // 画像描画パラメータに画像ファイルを設定
                paramDrawImage.setImageStream(inputImage);
                // 画像ページパラメータに画像描画パラメータを設定
                paramImagePage.setImage(paramDrawImage);
                // 画像ページのサイズを画像サイズにあわせる
                paramImagePage.setPaperType(PtlParamImagePage.PAPER_TYPE.PAPER_A4);
                // 画像の配置を設定
                paramImagePage.setAlign(PtlParamImagePage.ALIGN.ALIGN_CENTER);
                // ページコンテナに画像ページパラメータを追加
                pages.append(paramImagePage);
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
             System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                                "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

}
