/*
  Antenna House PDF Tool API V6.0
  Java Interface sample program

  概要：画像ファイルのPDF化(ステンシルマスクの使用)
  　　　マスク用画像を使ってステンシルマスクをかけます。
  　　　ステンシルマスク自体はモノクロのビットマップ画像ですが、マスクには色を指定できます。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


package cookbook;

import jp.co.antenna.ptl.*;

public class ImageToPdfStencilMask {
    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java ImageToPdfStencilMask mask-file" +
                           " out-pdf-file mask-colorR mask-colorG mask-colorB");
     }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 5) {
            printUsage();
            return;
        }

        //コマンドライン引数の取得
        float maskColorR = Float.parseFloat(args[2]);
        float maskColorG = Float.parseFloat(args[3]);
        float maskColorB = Float.parseFloat(args[4]);

        try (PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument();
             PtlPages pages = doc.getPages()) {  // ページコンテナの取得
            // 画像描画パラメータ
            // 画像ファイル
            // 画像ページパラメータ
            try (PtlParamDrawImage paramDrawImage = new PtlParamDrawImage();
                 PtlParamInput inputMask = new PtlParamInput(args[0]);
                 PtlParamImagePage paramImagePage = new PtlParamImagePage()) {
                // マスク用画像描画パラメータに画像ファイルを設定
                paramDrawImage.setImageStream(inputMask);

                // 指定した色のステンシルマスクを設定する
                try (PtlColorDeviceRGB colorRGB =
                     new PtlColorDeviceRGB(maskColorR, maskColorG, maskColorB)) {
                    paramDrawImage.setMaskColor(colorRGB,
                                                PtlParamDrawImage.MASK_TYPE.MASK_STENCIL);
                }

                // 画像ページパラメータに画像描画パラメータを設定
                paramImagePage.setImage(paramDrawImage);
                // 画像ページのサイズを画像サイズにあわせる
                paramImagePage.setPaperType(PtlParamImagePage.PAPER_TYPE.PAPER_IMAGE_SIZE);

                // ページコンテナに画像ページパラメータを追加
                pages.append(paramImagePage);
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
             System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                                "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
