/*
  Antenna House PDF Tool API V6.0
  Java Interface sample program

  概要：注釈の付いたPDFのマークアップ注釈を指定したPDFにインポートします。
  　　　その後、インポート済みのPDFを指定した名前で出力します。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


package cookbook;

import jp.co.antenna.ptl.*;

public class ImportAnnotsFromPDF {
    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.print("usage: java ImportAnnotsFromPDF in-pdf-file");
        System.out.println(" out-pdf-file pdf-file-to-import");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            printUsage();
            return;
        }

        // コマンドライン引数の取得
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlParamInput PdfToImport = new PtlParamInput(args[2]);
             PtlPDFDocument doc = new PtlPDFDocument();
             PtlPDFDocument docOfImportPDF = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);
            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.out.println("ページコンテナが空\n");
                    return;
                }
            }

            // インポート元のPDFファイルが空でないことを確認します。
            docOfImportPDF.load(PdfToImport);
            try (PtlPages pages = docOfImportPDF.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.out.println("ページコンテナが空\n");
                    return;
                }
            }
            // PDFファイルから注釈をインポートする
            doc.importAnnotsFromPDF(PdfToImport);

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
