/*
  Antenna House PDF Tool API V6.0
  Java Interface sample program

  概要：添付ファイルの書き出し

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import java.io.*;
import jp.co.antenna.ptl.*;

public class OutputEmbeddedFile {

    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java OutputEmbeddedFile in-pdf-file" +
                           " index-num-of-embedded-file write-file-name");
        System.out.println("index-num-of-embedded-file : " +
                           "何番目の添付ファイルを取り出すか指定する。（1～）");
     }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            printUsage();
            return;
        }

        //コマンドライン引数の読み取り
        int indexOfFile = Integer.parseInt(args[1]);
        String writeFileName = args[2];

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlPDFDocument doc = new PtlPDFDocument();
             PtlParamOutput writeFile = new PtlParamOutput(writeFileName)) {
            // PDFファイルをロード
            doc.load(inputFile);

            // 添付ファイルコンテナの取得
            try (PtlEmbeddedFiles embeddedFiles = doc.getEmbeddedFiles()) {
                // 添付ファイルコンテナが空かどうか
                if (embeddedFiles.isEmpty()) {
                    System.out.println("添付ファイルコンテナは空");
                    return;
                }

                // 添付ファイル数の取得
                int numOfEmbeddedFiles = embeddedFiles.getCount();
                System.out.println("添付ファイル数 : " + numOfEmbeddedFiles);

                // indexで指定した添付ファイルの取得。
                if(indexOfFile < numOfEmbeddedFiles){
                    System.out.println("index-num-of-embedded-fileは" +
                                       "添付ファイルの数より少ないものを" +
                                       "指定してください。");
                    return;
                }
                // 添付ファイルの書き出し
                // get()メソッドのパラメータindexは0スタートのため、
                // numToDeleteから-1しています。
                try (PtlEmbeddedFile embeddedfile = embeddedFiles.get(indexOfFile -1)) {
                    System.out.println(indexOfFile + "番目の添付ファイル名 : " +
                                       embeddedfile.getFileName());

                    // 添付ファイルの書き出し
                    System.out.println(indexOfFile +
                                       "番目の添付ファイルの書き出しをします。");
                    System.out.println("書き出しファイル名 : " + writeFileName);
                    embeddedfile.writeFile(writeFile);
                }
            }
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
