/*
  Antenna House PDF Tool API V6.0
  Java Interface sample program

  概要：注釈の削除
  　　　指定したindex番号または全ての注釈を削除する。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


package cookbook;

import jp.co.antenna.ptl.*;

public class RemoveAnnots {
    // そのクラスのusageを表示する関数
    public static void printUsage() {
        System.out.println("usage: java RemoveAnnots in-pdf-file" +
                           " out-pdf-file 削除したい注釈の指定");
        System.out.println("削除したい注釈の指定");
        System.out.println("0 : 全注釈の削除 0以外 : 指定したindex番号の削除");
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            printUsage();
            return;
        }
        int annotNumToRemove = Integer.parseInt(args[2]);

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {

            // PDFファイルをロードします。
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) // ページコンテナの取得
            {
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.out.println("ページコンテナが空\n");
                    return;
                }

                try (PtlPage page = pages.get(0);         // 1ページ目の取得
                     PtlAnnots annots = page.getAnnots()) {

                    // 注釈コンテナが空かどうか
                    if (annots.isEmpty()) {
                        System.out.println("注釈なし");
                    }
                    else
                    {
                        // 注釈数の取得
                        int numAnnots = annots.getCount();
                        System.out.println("注釈数 : " + numAnnots);
                        if (numAnnots == 0) {
                            System.out.println("このPDFには注釈は含まれておりません。");
                            return;
                        }

                        // 注釈の削除判定
                        switch (annotNumToRemove) {
                        case 0:
                            // 全注釈の削除
                            annots.removeAll();
                            break;
                        default:
                            if(numAnnots < annotNumToRemove){
                                System.out.println("削除する注釈のindex番号は" +
                                        "注釈数より少ないものを指定してください。");
                                return;
                            }
                            // 指定された添付ファイルの削除
                            // remove()メソッドのパラメータindexは0スタートのため、
                            // annotNumToRemoveから-1しています。
                            // 注釈の削除
                            annots.remove(annotNumToRemove - 1);
                            break;
                        }
                    }
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

}
