/*
  Antenna House PDF Tool API V6.0
  Java Interface sample program

  概要：添付ファイルの削除

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class RemoveEmbeddedFile {
    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java RemoveEmbeddedFile in-pdf-file" +
                           " out-pdf-file 削除するファイルの指定番号");
        System.out.println("削除するファイルの指定番号 :");
        System.out.println("0 : 添付ファイルの全削除" +
                           " その他の番号 : 数値で指定された添付ファイルの削除");
    }


    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            printUsage();
            return;
        }
        int fileNumToRemove = Integer.parseInt(args[2]);

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            // 添付ファイルコンテナの取得
            try (PtlEmbeddedFiles embeddedFiles = doc.getEmbeddedFiles())
            {
                // 添付ファイルコンテナが空かどうか
                if (embeddedFiles.isEmpty())
                {
                    System.out.println("添付ファイルコンテナは空");
                    return;
                }

                // 添付ファイル数の取得
                int numOfEmbeddedFiles = embeddedFiles.getCount();
                System.out.println("添付ファイル数 : " + numOfEmbeddedFiles);

                // 注釈の削除判定
                switch (fileNumToRemove) {
                case 0:
                    //全添付ファイルの削除
                    embeddedFiles.removeAll();
                    break;
                default:
                    if(fileNumToRemove > numOfEmbeddedFiles) {
                        System.out.println("削除するファイルの指定番号は" +
                                           "添付ファイル数より小さい数を指定して下さい。");
                        return;
                    }
                    // 指定された添付ファイルの削除
                    // remove()メソッドのパラメータindexは0スタートのため、
                    // fileNumToRemoveから-1しています。
                    embeddedFiles.remove(fileNumToRemove -1);
                    break;
                }

            }

            // ファイルに保存
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
