/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：文書情報の取得

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class SetCustomDocProperty {

    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java SetDocInfo in-pdf-file out-pdf-file" +
                           " custom-prop-name custom-prop-value");
     }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            printUsage();
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            try (PtlDocProperty docProperty = doc.getDocProperty(); //PDFの文書プロパティ
                 PtlCustomProperties customProperties  = docProperty.getCustomProperties();
                 PtlCustomProperty newCustomProp = new PtlCustomProperty(args[2],
                                                                         args[3])) {
                customProperties.append(newCustomProp);
            }
            // ファイルに保存します
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
