/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：文書情報の設定

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;
import java.time.LocalDateTime;
public class SetDocInfo {
    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java SetDocInfo in-pdf-file out-pdf-file" +
                           " タイトル 作者 "+
                           " 作成年 作成月 作成日 作成時 作成分");
     }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 9) {
            printUsage();
            return;
        }


        String title = args[2];
        String author = args[3];
        int createYear = Integer.parseInt(args[4]);
        int createMonth = Integer.parseInt(args[5]);
        int createDay = Integer.parseInt(args[6]);
        int createHour = Integer.parseInt(args[7]);
        int createMinute = Integer.parseInt(args[8]);
        int createSecond = 0; //分までの入力にし、秒は０にする。

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            try (PtlDocProperty docProperty = doc.getDocProperty(); // PDFの文書プロパティ
                 PtlDocInfo docinf = docProperty.getDocInfo()) {    // PDFの文書情報

                // タイトルを設定
                docinf.setTitle(title);
                // 著者を設定
                docinf.setAuthor(author);

                // 作成日付を設定
                try (PtlDate dateCreateNew = new PtlDate(createYear,
                                                         createMonth,
                                                         createDay,
                                                         createHour,
                                                         createMinute,
                                                         createSecond)) {
                    docinf.setCreationDate(dateCreateNew);
                }
                
                // 更新日付を設定(更新時の時間で作成)
                LocalDateTime timeNow = LocalDateTime.now();
                try (PtlDate dateModNew = new PtlDate(timeNow.getYear(),
                                                      timeNow.getMonthValue(),
                                                      timeNow.getDayOfMonth(),
                                                      timeNow.getHour(),
                                                      timeNow.getMinute(),
                                                      timeNow.getSecond())) {
                    docinf.setModDate(dateModNew);
                }
            }

            // ファイルに保存します
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}
